/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service;

import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PartnerAddress;
import com.axelor.apps.base.db.PartnerPriceList;
import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.repo.PartnerAddressRepository;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.message.db.EmailAddress;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.common.StringUtils;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.db.Query;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PartnerServiceImpl
implements PartnerService {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected PartnerRepository partnerRepo;
    protected AppBaseService appBaseService;
    private Pattern phoneNumberPattern = Pattern.compile("^\\+?(?:[0-9]{2,3}(?:\\s|\\.)?){3,6}[0-9]{2,3}$");

    @Inject
    public PartnerServiceImpl(PartnerRepository partnerRepo, AppBaseService appBaseService) {
        this.partnerRepo = partnerRepo;
        this.appBaseService = appBaseService;
    }

    @Override
    public Partner createPartner(String name, String firstName, String fixedPhone, String mobilePhone, EmailAddress emailAddress, Currency currency, Address deliveryAddress, Address mainInvoicingAddress, boolean createContact) {
        Partner partner = new Partner();
        partner.setName(name);
        partner.setFirstName(firstName);
        partner.setPartnerTypeSelect(1);
        partner.setIsProspect(true);
        partner.setFixedPhone(fixedPhone);
        partner.setMobilePhone(mobilePhone);
        partner.setEmailAddress(emailAddress);
        partner.setCurrency(currency);
        this.setPartnerFullName(partner);
        if (createContact) {
            Partner contact = this.createContact(partner, name, firstName, fixedPhone, mobilePhone, emailAddress != null ? new EmailAddress(emailAddress.getAddress()) : null, mainInvoicingAddress);
            partner.addContactPartnerSetItem(contact);
        }
        if (deliveryAddress == mainInvoicingAddress) {
            this.addPartnerAddress(partner, mainInvoicingAddress, true, true, true);
        } else {
            this.addPartnerAddress(partner, deliveryAddress, true, false, true);
            this.addPartnerAddress(partner, mainInvoicingAddress, true, true, false);
        }
        return partner;
    }

    @Override
    public Partner createContact(Partner partner, String name, String firstName, String fixedPhone, String mobilePhone, EmailAddress emailAddress, Address mainAddress) {
        Partner contact = new Partner();
        contact.setPartnerTypeSelect(2);
        contact.setIsContact(true);
        contact.setName(name);
        contact.setFirstName(firstName);
        contact.setMainPartner(partner);
        contact.setEmailAddress(emailAddress);
        contact.setMainAddress(mainAddress);
        this.setPartnerFullName(contact);
        return partner;
    }

    @Override
    public void onSave(Partner partner) throws AxelorException {
        long existEmailCount;
        if (partner.getPartnerSeq() == null && this.appBaseService.getAppBase().getGeneratePartnerSequence().booleanValue()) {
            String seq = ((SequenceService)Beans.get(SequenceService.class)).getSequenceNumber("partner");
            if (seq == null) {
                throw new AxelorException(4, I18n.get((String)"There is no sequence set for the partners"));
            }
            partner.setPartnerSeq(seq);
        }
        if (partner.getEmailAddress() != null && (existEmailCount = this.partnerRepo.all().filter("self.id != ?1 and self.emailAddress = ?2", new Object[]{partner.getId(), partner.getEmailAddress()}).count()) > 0L) {
            throw new AxelorException(2, I18n.get((String)"Email address already linked with another partner"));
        }
        this.updatePartnerAddress(partner);
        if (partner.getPartnerTypeSelect() == 2) {
            partner.setContactPartnerSet(new HashSet<Partner>());
        }
        if (!partner.getIsContact().booleanValue() && partner.getContactPartnerSet() != null) {
            for (Partner contact : partner.getContactPartnerSet()) {
                if (contact.getMainPartner() != null) continue;
                contact.setMainPartner(partner);
            }
        }
        this.setPartnerFullName(partner);
        this.setCompanyStr(partner);
    }

    protected void updatePartnerAddress(Partner partner) throws AxelorException {
        Address address = partner.getMainAddress();
        if (!partner.getIsContact().booleanValue() && !partner.getIsEmployee().booleanValue()) {
            if (partner.getPartnerAddressList() != null) {
                partner.setMainAddress(this.checkDefaultAddress(partner));
            }
        } else if (address == null) {
            partner.removePartnerAddressListItem((PartnerAddress)((Object)JPA.all(PartnerAddress.class).filter("self.partner = :partnerId AND self.isDefaultAddr = 't'").bind("partnerId", (Object)partner.getId()).fetchOne()));
        } else if (partner.getPartnerAddressList() != null) {
            if (partner.getPartnerAddressList().stream().map(PartnerAddress::getAddress).noneMatch(address::equals)) {
                PartnerAddress mainAddress = new PartnerAddress();
                mainAddress.setAddress(address);
                mainAddress.setIsDefaultAddr(true);
                mainAddress.setIsDeliveryAddr(true);
                mainAddress.setIsInvoicingAddr(true);
                partner.addPartnerAddressListItem(mainAddress);
            }
        }
    }

    protected Address checkDefaultAddress(Partner partner) throws AxelorException {
        List<PartnerAddress> partnerAddressList = partner.getPartnerAddressList();
        Address defaultInvoicingAddress = null;
        Address defaultDeliveryAddress = null;
        if (partnerAddressList != null) {
            for (PartnerAddress partnerAddress : partnerAddressList) {
                if (partnerAddress.getIsDefaultAddr().booleanValue() && partnerAddress.getIsInvoicingAddr().booleanValue()) {
                    if (defaultInvoicingAddress != null) {
                        throw new AxelorException(5, I18n.get((String)"You can select only one default invoicing address."));
                    }
                    defaultInvoicingAddress = partnerAddress.getAddress();
                }
                if (!partnerAddress.getIsDefaultAddr().booleanValue() || !partnerAddress.getIsDeliveryAddr().booleanValue()) continue;
                if (defaultDeliveryAddress != null) {
                    throw new AxelorException(5, I18n.get((String)"You can select only one default delivery address."));
                }
                defaultDeliveryAddress = partnerAddress.getAddress();
            }
        }
        return defaultInvoicingAddress;
    }

    @Override
    public void setPartnerFullName(Partner partner) {
        partner.setSimpleFullName(this.computeSimpleFullName(partner));
        partner.setFullName(this.computeFullName(partner));
    }

    @Override
    public String computeFullName(Partner partner) {
        if (!Strings.isNullOrEmpty((String)partner.getPartnerSeq())) {
            return partner.getPartnerSeq() + " - " + partner.getSimpleFullName();
        }
        return this.computeSimpleFullName(partner);
    }

    @Override
    public String computeSimpleFullName(Partner partner) {
        if (!Strings.isNullOrEmpty((String)partner.getName()) && !Strings.isNullOrEmpty((String)partner.getFirstName())) {
            return partner.getName() + " " + partner.getFirstName();
        }
        if (!Strings.isNullOrEmpty((String)partner.getName())) {
            return partner.getName();
        }
        if (!Strings.isNullOrEmpty((String)partner.getFirstName())) {
            return partner.getFirstName();
        }
        return "" + partner.getId();
    }

    @Override
    public Map<String, String> getSocialNetworkUrl(String name, String firstName, Integer typeSelect) {
        HashMap<String, String> urlMap = new HashMap<String, String>();
        if (typeSelect == 2) {
            name = firstName != null && name != null ? firstName + "+" + name : (name == null ? firstName : name);
        }
        name = name == null ? "" : name;
        urlMap.put("google", "<a class='fa fa-google' href='https://www.google.com/?gws_rd=cr#q=" + name + "' target='_blank' />");
        urlMap.put("facebook", "<a class='fa fa-facebook' href='https://www.facebook.com/search/more/?q=" + name + "&init=public' target='_blank'/>");
        urlMap.put("twitter", "<a class='fa fa-twitter' href='https://twitter.com/search?q=" + name + "' target='_blank' />");
        urlMap.put("linkedin", "<a class='fa fa-linkedin' href='https://www.linkedin.com/company/" + name + "' target='_blank' />");
        if (typeSelect == 2) {
            urlMap.put("linkedin", "<a class='fa fa-linkedin' href='http://www.linkedin.com/pub/dir/" + name.replace("+", "/") + "' target='_blank' />");
        }
        urlMap.put("youtube", "<a class='fa fa-youtube' href='https://www.youtube.com/results?search_query=" + name + "' target='_blank' />");
        return urlMap;
    }

    @Override
    public List<Long> findPartnerMails(Partner partner) {
        ArrayList<Long> idList = new ArrayList<Long>();
        idList.addAll(this.findMailsFromPartner(partner));
        Set<Partner> contactSet = partner.getContactPartnerSet();
        if (contactSet != null && !contactSet.isEmpty()) {
            for (Partner contact : contactSet) {
                idList.addAll(this.findMailsFromPartner(contact));
            }
        }
        return idList;
    }

    @Override
    public List<Long> findContactMails(Partner partner) {
        ArrayList<Long> idList = new ArrayList<Long>();
        idList.addAll(this.findMailsFromPartner(partner));
        return idList;
    }

    @Override
    public List<Long> findMailsFromPartner(Partner partner) {
        String query = "SELECT DISTINCT(email.id) FROM Message as email WHERE email.mediaTypeSelect = 2 AND (email.relatedTo1Select = 'com.axelor.apps.base.db.Partner' AND email.relatedTo1SelectId = " + partner.getId() + ") OR (email.relatedTo2Select = 'com.axelor.apps.base.db.Partner' AND email.relatedTo2SelectId = " + partner.getId() + ")";
        if (partner.getEmailAddress() != null) {
            query = query + "OR (email.fromEmailAddress.id = " + partner.getEmailAddress().getId() + ")";
        }
        return JPA.em().createQuery(query).getResultList();
    }

    private PartnerAddress createPartnerAddress(Address address, Boolean isDefault) {
        PartnerAddress partnerAddress = new PartnerAddress();
        partnerAddress.setAddress(address);
        partnerAddress.setIsDefaultAddr(isDefault);
        return partnerAddress;
    }

    @Override
    @Transactional
    public void resetDefaultAddress(Partner partner, String addrTypeQuery) {
        if (partner.getId() != null) {
            PartnerAddressRepository partnerAddressRepo = (PartnerAddressRepository)((Object)Beans.get(PartnerAddressRepository.class));
            PartnerAddress partnerAddress = (PartnerAddress)((Object)partnerAddressRepo.all().filter("self.partner.id = ? AND self.isDefaultAddr = true" + addrTypeQuery, new Object[]{partner.getId()}).fetchOne());
            if (partnerAddress != null) {
                partnerAddress.setIsDefaultAddr(false);
                partnerAddressRepo.save((Model)((Object)partnerAddress));
            }
        }
    }

    @Override
    public Partner addPartnerAddress(Partner partner, Address address, Boolean isDefault, Boolean isInvoicing, Boolean isDelivery) {
        PartnerAddress partnerAddress = this.createPartnerAddress(address, isDefault);
        if (isDefault != null && isDefault.booleanValue()) {
            LOG.debug("Add partner address : isDelivery = {}", (Object)isDelivery);
            LOG.debug("Add partner address : isInvoicing = {}", (Object)isInvoicing);
            String query = String.format(" AND self.isDeliveryAddr = %s AND self.isInvoicingAddr = %s", isDelivery, isInvoicing);
            this.resetDefaultAddress(partner, query);
        }
        partnerAddress.setIsInvoicingAddr(isInvoicing);
        partnerAddress.setIsDeliveryAddr(isDelivery);
        partnerAddress.setIsDefaultAddr(isDefault);
        partner.addPartnerAddressListItem(partnerAddress);
        return partner;
    }

    @Override
    public void addContactToPartner(Partner contact) {
        if (contact.getMainPartner() != null) {
            Partner partner = contact.getMainPartner();
            partner.addContactPartnerSetItem(contact);
            this.savePartner(partner);
        }
    }

    protected Address getAddress(Partner partner, String querySpecific, String queryComman) {
        if (partner != null) {
            PartnerAddressRepository partnerAddressRepo = (PartnerAddressRepository)((Object)Beans.get(PartnerAddressRepository.class));
            List partnerAddressList = partnerAddressRepo.all().filter(querySpecific, new Object[]{partner.getId()}).fetch();
            if (partnerAddressList.isEmpty() && (partnerAddressList = partnerAddressRepo.all().filter(queryComman, new Object[]{partner.getId()}).fetch()).isEmpty()) {
                partnerAddressList = partnerAddressRepo.all().filter("self.partner.id = ?1", new Object[]{partner.getId()}).fetch();
            }
            if (partnerAddressList.size() == 1) {
                return ((PartnerAddress)((Object)partnerAddressList.get(0))).getAddress();
            }
            for (PartnerAddress partnerAddress : partnerAddressList) {
                if (!partnerAddress.getIsDefaultAddr().booleanValue()) continue;
                return partnerAddress.getAddress();
            }
        }
        return null;
    }

    @Override
    public Address getInvoicingAddress(Partner partner) {
        return this.getAddress(partner, "self.partner.id = ?1 AND self.isInvoicingAddr = true AND self.isDeliveryAddr = false AND self.isDefaultAddr = true", "self.partner.id = ?1 AND self.isInvoicingAddr = true");
    }

    @Override
    public Address getDeliveryAddress(Partner partner) {
        return this.getAddress(partner, "self.partner.id = ?1 AND self.isDeliveryAddr = true AND self.isInvoicingAddr = false AND self.isDefaultAddr = true", "self.partner.id = ?1 AND self.isDeliveryAddr = true");
    }

    @Override
    public Address getDefaultAddress(Partner partner) {
        return this.getAddress(partner, "self.partner.id = ?1 AND self.isDeliveryAddr = true AND self.isInvoicingAddr = true AND self.isDefaultAddr = true", "self.partner.id = ?1 AND self.isDefaultAddr = true");
    }

    @Override
    @Transactional
    public Partner savePartner(Partner partner) {
        return (Partner)((Object)this.partnerRepo.save((Model)((Object)partner)));
    }

    @Override
    public BankDetails getDefaultBankDetails(Partner partner) {
        for (BankDetails bankDetails : partner.getBankDetailsList()) {
            if (!bankDetails.getIsDefault().booleanValue()) continue;
            return bankDetails;
        }
        return null;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public String getSIRENNumber(Partner partner) throws AxelorException {
        char[] Str = new char[9];
        if (partner == null) {
            throw new AxelorException(4, I18n.get((String)"%s SIRET Number required. Please configure SIRET Number for partner %s"), new Object[]{I18n.get((String)"Warning !"), ""});
        }
        if (partner.getRegistrationCode() == null || partner.getRegistrationCode().isEmpty()) {
            throw new AxelorException((Model)((Object)partner), 4, I18n.get((String)"%s SIRET Number required. Please configure SIRET Number for partner %s"), new Object[]{I18n.get((String)"Warning !"), partner.getName()});
        }
        String registrationCode = partner.getRegistrationCode();
        registrationCode.replaceAll("\\s", "").getChars(0, 9, Str, 0);
        return new String(Str);
    }

    @Override
    @Transactional
    public void convertToIndividualPartner(Partner partner) {
        partner.setIsContact(false);
        partner.setPartnerTypeSelect(2);
        this.addPartnerAddress(partner, partner.getMainAddress(), true, false, false);
        partner.setMainAddress(null);
    }

    @Override
    public boolean isThereDuplicatePartner(Partner partner) {
        return this.isThereDuplicatePartnerQuery(partner, false) != null;
    }

    @Override
    public PriceList getSalePriceList(Partner partner) {
        PartnerPriceList partnerPriceList = partner.getSalePartnerPriceList();
        if (partnerPriceList == null) {
            return null;
        }
        Set<PriceList> priceListSet = partnerPriceList.getPriceListSet();
        if (priceListSet == null) {
            return null;
        }
        LocalDate today = ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate(Optional.ofNullable(AuthUtils.getUser()).map(User::getActiveCompany).orElse(null));
        ArrayList<PriceList> candidatePriceListList = new ArrayList<PriceList>();
        for (PriceList priceList : priceListSet) {
            LocalDate endDate;
            LocalDate beginDate = priceList.getApplicationBeginDate() != null ? priceList.getApplicationBeginDate() : LocalDate.MIN;
            LocalDate localDate = endDate = priceList.getApplicationEndDate() != null ? priceList.getApplicationEndDate() : LocalDate.MAX;
            if (beginDate.compareTo(today) > 0 || today.compareTo(endDate) > 0) continue;
            candidatePriceListList.add(priceList);
        }
        if (candidatePriceListList.size() == 1) {
            return (PriceList)((Object)candidatePriceListList.get(0));
        }
        return null;
    }

    @Override
    public String getPartnerLanguageCode(Partner partner) {
        String locale = null;
        if (partner != null && partner.getLanguage() != null) {
            locale = partner.getLanguage().getCode();
        }
        if (!Strings.isNullOrEmpty(locale)) {
            return locale;
        }
        return ((AppBaseService)Beans.get(AppBaseService.class)).getDefaultPartnerLanguageCode();
    }

    @Override
    public String normalizePhoneNumber(String phoneNumber) {
        return StringUtils.isBlank((CharSequence)phoneNumber) ? null : phoneNumber.replaceAll("\\s|\\.|-", "");
    }

    @Override
    public boolean checkPhoneNumber(String phoneNumber) {
        return StringUtils.isBlank((CharSequence)phoneNumber) ? false : this.phoneNumberPattern.matcher(phoneNumber).matches();
    }

    @Override
    public String getPhoneNumberFieldName(String actionName) {
        Preconditions.checkNotNull((Object)actionName, (Object)I18n.get((String)"Action name cannot be null."));
        return actionName.substring(actionName.lastIndexOf(45) + 1);
    }

    @Override
    public void setCompanyStr(Partner partner) {
        partner.setCompanyStr(this.computeCompanyStr(partner));
    }

    @Override
    public String computeCompanyStr(Partner partner) {
        String companyStr = "";
        if (partner.getCompanySet() != null && partner.getCompanySet().size() > 0) {
            for (Company company : partner.getCompanySet()) {
                companyStr = companyStr + company.getCode() + ",";
            }
            return companyStr.substring(0, companyStr.length() - 1);
        }
        return null;
    }

    @Override
    public String getPartnerDomain(Partner partner) {
        String domain = "";
        if (partner != null) {
            if (partner.getCurrency() != null) {
                domain = domain + String.format(" AND self.currency.id = %d", partner.getCurrency().getId());
            }
            if (partner.getSalePartnerPriceList() != null) {
                domain = domain + String.format(" AND self.salePartnerPriceList.id = %s", partner.getSalePartnerPriceList().getId());
            }
            if (partner.getFiscalPosition() != null) {
                domain = domain + String.format(" AND self.fiscalPosition.id = %s", partner.getFiscalPosition().getId());
            }
        }
        return domain;
    }

    @Override
    public Partner isThereDuplicatePartnerInArchive(Partner partner) {
        return this.isThereDuplicatePartnerQuery(partner, true);
    }

    protected Partner isThereDuplicatePartnerQuery(Partner partner, boolean isInArchived) {
        String newName = this.computeSimpleFullName(partner);
        if (Strings.isNullOrEmpty((String)newName)) {
            return null;
        }
        Long partnerId = partner.getId();
        String filter = "lower(self.simpleFullName) = lower(:newName) and self.partnerTypeSelect = :_partnerTypeSelect ";
        if (partner != null) {
            filter = filter + "and self.id != :partnerId ";
        }
        filter = isInArchived ? filter + "and self.archived = true " : filter + "and ( self.archived != true OR self.archived is null ) ";
        Query partnerQuery = this.partnerRepo.all().filter(filter).bind("newName", (Object)newName).bind("_partnerTypeSelect", (Object)partner.getPartnerTypeSelect());
        if (partner != null) {
            partnerQuery = partnerQuery.bind("partnerId", (Object)partnerId);
        }
        return (Partner)((Object)partnerQuery.fetchOne());
    }
}

