/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service;

import com.axelor.apps.base.db.PriceList;
import com.axelor.apps.base.db.PriceListLine;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.repo.PriceListLineRepository;
import com.axelor.apps.base.db.repo.PriceListRepository;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class PriceListService {
    @Inject
    private PriceListLineRepository priceListLineRepo;
    @Inject
    private PriceListRepository priceListRepo;
    @Inject
    protected AppBaseService appBaseService;

    public PriceListLine getPriceListLine(Product product, BigDecimal qty, PriceList priceList, BigDecimal price) {
        PriceListLine priceListLine = null;
        List priceListLineList = null;
        BigDecimal tempDiscountPrevious = null;
        BigDecimal tempDiscountCurrent = null;
        if (product != null && priceList != null && ((priceListLineList = ((PriceListLineRepository)((Object)Beans.get(PriceListLineRepository.class))).all().filter("self.product = ?1 AND self.minQty <= ?2 AND self.priceList.id = ?3 ORDER BY self.minQty DESC", new Object[]{product, qty, priceList.getId()}).fetch()) == null || priceListLineList.isEmpty()) && product.getProductCategory() != null) {
            priceListLineList = this.priceListLineRepo.all().filter("self.productCategory = ?1 AND self.minQty <= ?2 AND self.priceList.id = ?3 ORDER BY self.minQty DESC", new Object[]{product.getProductCategory(), qty, priceList.getId()}).fetch();
        }
        if (priceListLineList != null && !priceListLineList.isEmpty()) {
            if (priceListLineList.size() > 1) {
                for (PriceListLine tempPriceListLine : priceListLineList) {
                    tempDiscountCurrent = this.getUnitPriceDiscounted(tempPriceListLine, price);
                    if (tempDiscountPrevious != null && tempDiscountPrevious.compareTo(tempDiscountCurrent) != 1) continue;
                    tempDiscountPrevious = tempDiscountCurrent;
                    priceListLine = tempPriceListLine;
                }
            } else {
                priceListLine = (PriceListLine)((Object)priceListLineList.get(0));
            }
        }
        return priceListLine;
    }

    public int getDiscountTypeSelect(PriceListLine priceListLine) {
        return priceListLine.getAmountTypeSelect();
    }

    public BigDecimal getDiscountAmount(PriceListLine priceListLine, BigDecimal unitPrice) {
        switch (priceListLine.getTypeSelect()) {
            case 2: {
                return priceListLine.getAmount().negate();
            }
            case 1: {
                return priceListLine.getAmount();
            }
            case 3: {
                return unitPrice.subtract(priceListLine.getAmount());
            }
        }
        return BigDecimal.ZERO;
    }

    public BigDecimal getUnitPriceDiscounted(PriceListLine priceListLine, BigDecimal unitPrice) {
        switch (priceListLine.getTypeSelect()) {
            case 2: {
                if (priceListLine.getAmountTypeSelect() == 2) {
                    return unitPrice.add(priceListLine.getAmount());
                }
                if (priceListLine.getAmountTypeSelect() == 1) {
                    return unitPrice.multiply(BigDecimal.ONE.add(priceListLine.getAmount().divide(new BigDecimal(100))));
                }
            }
            case 1: {
                if (priceListLine.getAmountTypeSelect() == 2) {
                    return unitPrice.subtract(priceListLine.getAmount());
                }
                if (priceListLine.getAmountTypeSelect() == 1) {
                    return unitPrice.multiply(BigDecimal.ONE.subtract(priceListLine.getAmount().divide(new BigDecimal(100))));
                }
            }
            case 3: {
                return priceListLine.getAmount();
            }
        }
        return unitPrice;
    }

    public BigDecimal getUnitPriceDiscounted(PriceList priceList, BigDecimal unitPrice) {
        BigDecimal discountPercent = priceList.getGeneralDiscount();
        return unitPrice.multiply(BigDecimal.ONE.subtract(discountPercent.divide(new BigDecimal(100))));
    }

    public BigDecimal computeDiscount(BigDecimal unitPrice, int discountTypeSelect, BigDecimal discountAmount) {
        if (discountTypeSelect == 2) {
            return unitPrice.subtract(discountAmount).setScale(this.appBaseService.getNbDecimalDigitForUnitPrice(), RoundingMode.HALF_UP);
        }
        if (discountTypeSelect == 1) {
            return unitPrice.multiply(new BigDecimal(100).subtract(discountAmount)).divide(new BigDecimal(100), this.appBaseService.getNbDecimalDigitForUnitPrice(), RoundingMode.HALF_UP);
        }
        return unitPrice;
    }

    public Map<String, Object> getReplacedPriceAndDiscounts(PriceList priceList, PriceListLine priceListLine, BigDecimal price) {
        int computeMethodDiscountSelect;
        Map<String, Object> discounts;
        int discountTypeSelect = 0;
        if (priceListLine != null) {
            discountTypeSelect = priceListLine.getTypeSelect();
        }
        if ((discounts = this.getDiscounts(priceList, priceListLine, price)) != null && ((computeMethodDiscountSelect = this.appBaseService.getAppBase().getComputeMethodDiscountSelect().intValue()) == 2 && discountTypeSelect == 3 || computeMethodDiscountSelect == 3)) {
            price = this.computeDiscount(price, (Integer)discounts.get("discountTypeSelect"), (BigDecimal)discounts.get("discountAmount"));
            discounts.put("price", price);
            discounts.put("discountTypeSelect", 0);
            discounts.put("discountAmount", BigDecimal.ZERO);
        }
        return discounts;
    }

    public Map<String, Object> getDiscounts(PriceList priceList, PriceListLine priceListLine, BigDecimal price) {
        HashMap<String, Object> discounts = new HashMap<String, Object>();
        if (priceListLine != null) {
            discounts.put("discountAmount", this.getDiscountAmount(priceListLine, price).setScale(this.appBaseService.getNbDecimalDigitForUnitPrice(), RoundingMode.HALF_UP));
            discounts.put("discountTypeSelect", this.getDiscountTypeSelect(priceListLine));
        } else {
            BigDecimal discountAmount = priceList.getGeneralDiscount().setScale(this.appBaseService.getNbDecimalDigitForUnitPrice(), RoundingMode.HALF_UP);
            discounts.put("discountAmount", discountAmount);
            if (discountAmount.compareTo(BigDecimal.ZERO) == 0) {
                discounts.put("discountTypeSelect", 0);
            } else {
                discounts.put("discountTypeSelect", 1);
            }
        }
        return discounts;
    }

    @Transactional
    public PriceList historizePriceList(PriceList priceList) {
        PriceList historizedPriceList = (PriceList)((Object)this.priceListRepo.copy((Model)((Object)priceList), false));
        historizedPriceList.setIsActive(false);
        List<PriceListLine> priceListLineList = priceList.getPriceListLineList();
        for (PriceListLine priceListLine : priceListLineList) {
            PriceListLine newPriceListLine = (PriceListLine)((Object)this.priceListLineRepo.copy((Model)((Object)priceListLine), false));
            newPriceListLine.setPriceList(null);
            historizedPriceList.addPriceListLineListItem(newPriceListLine);
        }
        this.priceListRepo.save((Model)((Object)historizedPriceList));
        priceList.addHistorizedPriceListItem(historizedPriceList);
        this.priceListRepo.save((Model)((Object)priceList));
        return priceList;
    }

    public void checkDates(PriceList priceList) throws AxelorException {
        LocalDate beginDate = priceList.getApplicationBeginDate();
        LocalDate endDate = priceList.getApplicationEndDate();
        if (beginDate == null || endDate == null) {
            return;
        }
        if (beginDate.compareTo(endDate) > 0) {
            throw new AxelorException(4, I18n.get((String)"The end date is before the begin date."));
        }
    }
}

