/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.ProductCompany;
import com.axelor.apps.base.service.ProductCompanyService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.db.mapper.Mapper;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.meta.CallMethod;
import com.axelor.meta.db.MetaField;
import com.google.inject.Inject;
import java.util.Set;

public class ProductCompanyServiceImpl
implements ProductCompanyService {
    @Inject
    protected AppBaseService appBaseService;

    @Override
    @CallMethod
    public Object get(Product originalProduct, String fieldName, Company company) throws AxelorException {
        Mapper mapper = Mapper.of(Product.class);
        Product product = this.findAppropriateProductCompany(originalProduct, fieldName, company);
        return mapper.get((Object)product, fieldName);
    }

    @Override
    @CallMethod
    public void set(Product originalProduct, String fieldName, Object fieldValue, Company company) throws AxelorException {
        Mapper mapper = Mapper.of(Product.class);
        Product product = this.findAppropriateProductCompany(originalProduct, fieldName, company);
        mapper.set((Object)product, fieldName, fieldValue);
    }

    private Product findAppropriateProductCompany(Product originalProduct, String fieldName, Company company) throws AxelorException {
        if (originalProduct == null) {
            throw new AxelorException(1, I18n.get((String)"Attempted to get field '%s' for unspecified product."), new Object[]{fieldName});
        }
        if (fieldName == null || fieldName.trim().equals("")) {
            throw new AxelorException(1, I18n.get((String)"Attempted to get a field from product '%s' but forgot to specify which field."), new Object[]{originalProduct.getFullName()});
        }
        Product product = originalProduct;
        if (company != null && originalProduct.getProductCompanyList() != null) {
            block0: for (ProductCompany productCompany : originalProduct.getProductCompanyList()) {
                if (productCompany.getCompany().getId() != company.getId()) continue;
                Set<MetaField> companySpecificFields = this.appBaseService.getAppBase().getCompanySpecificProductFieldsList();
                for (MetaField field : companySpecificFields) {
                    if (!field.getName().equals(fieldName)) continue;
                    product = productCompany;
                    break block0;
                }
            }
        }
        return product;
    }
}

