/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service;

import com.axelor.apps.base.db.ProductMultipleQty;
import com.axelor.apps.base.service.ProductMultipleQtyService;
import com.axelor.apps.tool.ContextTool;
import com.axelor.i18n.I18n;
import com.axelor.rpc.ActionResponse;
import com.google.common.base.Strings;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProductMultipleQtyServiceImpl
implements ProductMultipleQtyService {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public boolean checkMultipleQty(BigDecimal qty, List<ProductMultipleQty> productMultipleQties) {
        if (productMultipleQties.size() == 0) {
            return true;
        }
        for (ProductMultipleQty productMultipleQty : productMultipleQties) {
            if (productMultipleQty.getMultipleQty().compareTo(BigDecimal.ZERO) == 0) continue;
            LOG.debug("Check on multiple qty : {}, Modulo : {}", (Object)qty, (Object)qty.remainder(productMultipleQty.getMultipleQty()));
            if (qty.remainder(productMultipleQty.getMultipleQty()).compareTo(BigDecimal.ZERO) != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public String toStringMultipleQty(List<ProductMultipleQty> productMultipleQties) {
        String message = "";
        for (ProductMultipleQty productMultipleQty : productMultipleQties) {
            if (message.length() > 0) {
                message = message + " " + I18n.get((String)"or") + " ";
            }
            message = message + productMultipleQty.getMultipleQty();
            if (Strings.isNullOrEmpty((String)productMultipleQty.getName())) continue;
            message = message + " (" + productMultipleQty.getName() + ")";
        }
        return message;
    }

    @Override
    public void checkMultipleQty(BigDecimal qty, List<ProductMultipleQty> productMultipleQties, boolean allowToForce, ActionResponse response) {
        boolean isMultiple = this.checkMultipleQty(qty, productMultipleQties);
        if (isMultiple) {
            response.setAttr("multipleQtyNotRespectedLabel", "hidden", (Object)true);
            response.setValue("$qtyValid", (Object)true);
        } else {
            String spanClass = allowToForce ? ContextTool.SPAN_CLASS_WARNING : ContextTool.SPAN_CLASS_IMPORTANT;
            String message = String.format(I18n.get((String)"Quantity should be a multiple of %s"), this.toStringMultipleQty(productMultipleQties));
            String title = ContextTool.formatLabel((String)message, (String)spanClass, (int)75);
            response.setAttr("multipleQtyNotRespectedLabel", "title", (Object)title);
            response.setAttr("multipleQtyNotRespectedLabel", "hidden", (Object)false);
            response.setValue("$qtyValid", (Object)allowToForce);
        }
    }
}

