/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.db.UnitConversion;
import com.axelor.apps.base.db.repo.UnitConversionRepository;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.tool.template.TemplateMaker;
import com.google.inject.Inject;
import com.google.inject.servlet.RequestScoped;
import groovy.lang.Binding;
import groovy.lang.GroovyShell;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.codehaus.groovy.control.CompilationFailedException;
import org.codehaus.groovy.control.CompilerConfiguration;
import org.codehaus.groovy.control.customizers.CompilationCustomizer;
import org.codehaus.groovy.control.customizers.ImportCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RequestScoped
public class UnitConversionService {
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final char TEMPLATE_DELIMITER = '$';
    private static final int DEFAULT_COEFFICIENT_SCALE = 12;
    protected TemplateMaker maker;
    @Inject
    protected AppBaseService appBaseService;
    @Inject
    protected UnitConversionRepository unitConversionRepo;

    public BigDecimal convert(Unit startUnit, Unit endUnit, BigDecimal value, int scale, Product product) throws AxelorException {
        if (startUnit == null && endUnit == null) {
            throw new AxelorException(4, I18n.get((String)"Conversion impossible because of no unit."));
        }
        if (startUnit == null && endUnit != null) {
            throw new AxelorException(4, I18n.get((String)"Start unit cannot be void."));
        }
        if (endUnit == null && startUnit != null) {
            throw new AxelorException(4, I18n.get((String)"End unit cannot be void."));
        }
        if (startUnit.equals((Object)endUnit)) {
            return value;
        }
        try {
            BigDecimal coefficient = this.getCoefficient(this.unitConversionRepo.all().fetch(), startUnit, endUnit, product);
            return value.multiply(coefficient).setScale(scale, RoundingMode.HALF_EVEN);
        }
        catch (IOException | ClassNotFoundException e) {
            TraceBackService.trace((Throwable)e);
            return value;
        }
    }

    public BigDecimal getCoefficient(List<? extends UnitConversion> unitConversionList, Unit startUnit, Unit endUnit, Product product) throws AxelorException, CompilationFailedException, ClassNotFoundException, IOException {
        if (product != null) {
            this.maker = new TemplateMaker(Optional.ofNullable(AuthUtils.getUser()).map(User::getActiveCompany).orElse(null) != null ? (String)Optional.ofNullable(AuthUtils.getUser()).map(User::getActiveCompany).map(Company::getTimezone).orElse(null) : "", Locale.FRENCH, '$', '$');
            this.maker.setContext((Model)((Object)product), "Product");
        }
        String eval = null;
        for (UnitConversion unitConversion : unitConversionList) {
            GroovyShell shell;
            Binding binding;
            ImportCustomizer customizer;
            CompilerConfiguration conf;
            if (unitConversion.getStartUnit().equals((Object)startUnit) && unitConversion.getEndUnit().equals((Object)endUnit)) {
                if (unitConversion.getTypeSelect() == 1) {
                    return unitConversion.getCoef();
                }
                if (product != null) {
                    this.maker.setTemplate(unitConversion.getFormula());
                    eval = this.maker.make();
                    conf = new CompilerConfiguration();
                    customizer = new ImportCustomizer();
                    customizer.addStaticStars(new String[]{"java.lang.Math"});
                    conf.addCompilationCustomizers(new CompilationCustomizer[]{customizer});
                    binding = new Binding();
                    shell = new GroovyShell(binding, conf);
                    return new BigDecimal(shell.evaluate(eval).toString());
                }
            }
            if (!unitConversion.getStartUnit().equals((Object)endUnit) || !unitConversion.getEndUnit().equals((Object)startUnit)) continue;
            if (unitConversion.getTypeSelect() == 1 && unitConversion.getCoef().compareTo(BigDecimal.ZERO) != 0) {
                return BigDecimal.ONE.divide(unitConversion.getCoef(), 12, RoundingMode.HALF_EVEN);
            }
            if (product == null) continue;
            this.maker.setTemplate(unitConversion.getFormula());
            eval = this.maker.make();
            conf = new CompilerConfiguration();
            customizer = new ImportCustomizer();
            customizer.addStaticStars(new String[]{"java.lang.Math"});
            conf.addCompilationCustomizers(new CompilationCustomizer[]{customizer});
            binding = new Binding();
            shell = new GroovyShell(binding, conf);
            BigDecimal result = new BigDecimal(shell.evaluate(eval).toString());
            if (result.compareTo(BigDecimal.ZERO) == 0) continue;
            return BigDecimal.ONE.divide(result, 12, RoundingMode.HALF_EVEN);
        }
        throw new AxelorException(4, I18n.get((String)"Please configure unit conversion from '%s' to '%s'."), new Object[]{startUnit.getName(), endUnit.getName()});
    }
}

