/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Period;
import com.axelor.apps.base.db.Year;
import com.axelor.apps.base.db.repo.YearRepository;
import com.axelor.apps.base.service.YearService;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;

public class YearServiceImpl
implements YearService {
    protected YearRepository yearRepository;

    @Inject
    public YearServiceImpl(YearRepository yearRepository) {
        this.yearRepository = yearRepository;
    }

    @Override
    public List<Period> generatePeriods(Year year) throws AxelorException {
        ArrayList<Period> periods = new ArrayList<Period>();
        Integer duration = year.getPeriodDurationSelect();
        LocalDate fromDate = year.getFromDate();
        LocalDate toDate = year.getToDate();
        LocalDate periodToDate = fromDate;
        Integer periodNumber = 1;
        int c = 0;
        int loopLimit = 1000;
        while (periodToDate.isBefore(toDate)) {
            if (periodNumber != 1) {
                fromDate = fromDate.plusMonths(duration.intValue());
            }
            if (c >= loopLimit) {
                throw new AxelorException(5, I18n.get((String)"Too much iterations."));
            }
            ++c;
            periodToDate = fromDate.plusMonths(duration.intValue()).minusDays(1L);
            if (periodToDate.isAfter(toDate)) {
                periodToDate = toDate;
            }
            if (fromDate.isAfter(toDate)) continue;
            Period period = new Period();
            period.setFromDate(fromDate);
            period.setToDate(periodToDate);
            period.setYear(year);
            period.setName(String.format("%02d", periodNumber) + "/" + year.getCode());
            period.setCode((String.format("%02d", periodNumber) + "/" + year.getCode() + "_" + year.getCompany().getCode()).toUpperCase());
            period.setStatusSelect(year.getStatusSelect());
            periods.add(period);
            Integer n = periodNumber;
            Integer n2 = periodNumber = Integer.valueOf(periodNumber + 1);
        }
        return periods;
    }

    @Override
    public Year getYear(LocalDate date, Company company, Integer type) {
        return (Year)((Object)this.yearRepository.all().filter("self.company = ?1 AND self.fromDate <= ?2 AND self.toDate >= ?2 AND self.typeSelect = ?3", new Object[]{company, date, type}).fetchOne());
    }
}

