/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.administration;

import com.axelor.apps.base.db.Batch;
import com.axelor.apps.base.db.repo.BatchRepository;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.auth.db.AuditableModel;
import com.axelor.db.EntityHelper;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.i18n.I18n;
import com.google.common.base.Preconditions;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.time.ZonedDateTime;
import java.time.temporal.ChronoUnit;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractBatch {
    private static final ThreadLocal<Long> threadBatchId = new ThreadLocal();
    public static final int FETCH_LIMIT = 10;
    @Inject
    protected AppBaseService appBaseService;
    protected static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected Batch batch = new Batch();
    protected Model model;
    @Inject
    protected BatchRepository batchRepo;
    private int done;
    private int anomaly;

    protected AbstractBatch() {
        this.batch.setStartDate(ZonedDateTime.now());
        this.done = 0;
        this.anomaly = 0;
        this.batch.setDone(this.done);
        this.batch.setAnomaly(this.anomaly);
        JPA.runInTransaction(() -> {
            this.batch = (Batch)((Object)((Object)JPA.persist((Model)((Object)this.batch))));
        });
    }

    public Batch getBatch() {
        return this.batch;
    }

    public static Batch getCurrentBatch() {
        return (Batch)((Object)JPA.find(Batch.class, (Long)AbstractBatch.getCurrentBatchId()));
    }

    public static long getCurrentBatchId() {
        Long id = threadBatchId.get();
        return id == null ? 0L : id;
    }

    public Batch run(AuditableModel model) {
        Preconditions.checkNotNull((Object)model);
        if (threadBatchId.get() != null) {
            throw new IllegalStateException(I18n.get((String)"Nested batch execution!"));
        }
        if (this.isRunnable((Model)model)) {
            try {
                threadBatchId.set(this.batch.getId());
                this.start();
                this.process();
                this.stop();
                Batch batch = this.batch;
                return batch;
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                threadBatchId.remove();
                this.unarchived();
            }
        }
        throw new RuntimeException(I18n.get((String)"This batch is not runnable!"));
    }

    protected abstract void process();

    protected boolean isRunnable(Model model) {
        this.model = model;
        return !Boolean.TRUE.equals(model.getArchived());
    }

    protected void start() throws IllegalAccessException {
        LOG.info("D\u00e9but batch {} ::: {}", (Object)this.model, (Object)this.batch.getStartDate());
        this.model.setArchived(true);
        this.associateModel();
        this.checkPoint();
    }

    protected void stop() {
        this.findBatch();
        this.batch.setEndDate(ZonedDateTime.now());
        this.batch.setDuration(this.getDuring());
        this.checkPoint();
        LOG.info("Fin batch {} ::: {}", (Object)this.model, (Object)this.batch.getEndDate());
    }

    protected void incrementDone() {
        this.findBatch();
        this._incrementDone();
    }

    protected void _incrementDone() {
        ++this.done;
        this.batch.setDone(this.done);
        this.checkPoint();
        LOG.debug("Done ::: {}", (Object)this.done);
    }

    protected void incrementAnomaly() {
        this.findBatch();
        this._incrementAnomaly();
    }

    protected void _incrementAnomaly() {
        ++this.anomaly;
        this.batch.setAnomaly(this.anomaly);
        this.checkPoint();
        LOG.debug("Anomaly ::: {}", (Object)this.anomaly);
    }

    protected void addComment(String comment) {
        this.findBatch();
        this.batch.setComments(comment);
        this.checkPoint();
    }

    @Transactional
    protected Batch checkPoint() {
        return this.findBatch();
    }

    @Transactional
    protected void unarchived() {
        try {
            Class entityClass = EntityHelper.getEntityClass((Object)this.model);
            Long modelId = this.model.getId();
            this.model = JPA.find((Class)entityClass, (Long)modelId);
            this.model.setArchived(false);
        }
        catch (Exception e) {
            LOG.error(e.getMessage(), (Throwable)e);
        }
    }

    private Long getDuring() {
        return ChronoUnit.MINUTES.between(this.batch.getStartDate(), this.batch.getEndDate());
    }

    private void associateModel() throws IllegalAccessException {
        LOG.debug("ASSOCIATE batch:{} TO model:{}", (Object)this.batch, (Object)this.model);
        for (Field field : ((Object)((Object)this.batch)).getClass().getDeclaredFields()) {
            LOG.debug("TRY TO ASSOCIATE field:{} TO model:{}", (Object)field.getType().getName(), (Object)this.model.getClass().getName());
            if (!this.isAssociable(field)) continue;
            LOG.debug("FIELD ASSOCIATE TO MODEL");
            field.setAccessible(true);
            field.set((Object)this.batch, this.model);
            field.setAccessible(false);
            break;
        }
    }

    private boolean isAssociable(Field field) {
        return field.getType().equals(EntityHelper.getEntityClass((Object)this.model));
    }

    protected Batch findBatch() {
        if (!JPA.em().contains((Object)this.batch)) {
            this.batch = (Batch)((Object)JPA.find(Batch.class, (Long)this.batch.getId()));
        }
        return this.batch;
    }
}

