/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.administration;

import com.axelor.app.AppSettings;
import com.axelor.apps.base.service.administration.XmlHandler;
import com.axelor.apps.base.service.user.UserService;
import com.axelor.apps.tool.file.CsvTool;
import com.axelor.apps.tool.xml.XPathParse;
import com.axelor.auth.db.Group;
import com.axelor.auth.db.repo.GroupRepository;
import com.axelor.db.Model;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaAction;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.db.MetaMenu;
import com.axelor.meta.db.MetaTranslation;
import com.axelor.meta.db.repo.MetaFileRepository;
import com.axelor.meta.db.repo.MetaMenuRepository;
import com.axelor.meta.db.repo.MetaTranslationRepository;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ExportDbObjectService {
    @Inject
    UserService uis;
    private static final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static String[] fieldAttrs = new String[]{"name", "type", "title"};
    public String[] csvHeaders = new String[]{"object", "module", "name", "type", "title_en", "title_fr", "help_en", "help_fr", "url"};
    private List<String[]> fieldDataList = new ArrayList<String[]>();
    private List<String> objectList = new ArrayList<String>();
    private Map<String, Object> objectMap = new HashMap<String, Object>();
    private Group group = null;

    @Transactional
    public MetaFile exportObject() {
        this.group = (Group)((Object)((GroupRepository)((Object)Beans.get(GroupRepository.class))).all().filter("self.code = 'admins'").fetchOne());
        try {
            log.debug("Attachment dir: {}", (Object)AppSettings.get().get("file.upload.dir"));
            String uploadDir = AppSettings.get().get("file.upload.dir");
            if (uploadDir == null || !new File(uploadDir).exists()) {
                return null;
            }
            String appSrc = AppSettings.get().get("application.src");
            log.debug("Module dir: {}", (Object)appSrc);
            if (appSrc == null) {
                return null;
            }
            File moduleDir = new File(appSrc);
            if (!moduleDir.exists()) {
                return null;
            }
            MetaFile metaFile = new MetaFile();
            String fileName = "ExportObject-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyMMddHHmmSS")) + ".csv";
            metaFile.setFileName(fileName);
            metaFile.setFilePath(fileName);
            metaFile = (MetaFile)((MetaFileRepository)Beans.get(MetaFileRepository.class)).save((Model)metaFile);
            SAXParserFactory saxParserFactory = SAXParserFactory.newInstance();
            saxParserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
            this.updateObjectMap(Arrays.asList(moduleDir.listFiles()), saxParserFactory.newSAXParser(), new XmlHandler());
            this.writeObjects(MetaFiles.getPath((MetaFile)metaFile).toFile());
            return metaFile;
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void writeObjects(File objectFile) {
        try {
            List menuList = ((MetaMenuRepository)Beans.get(MetaMenuRepository.class)).all().filter("self.parent = null AND self.left = true AND ?1 MEMBER OF self.groups", new Object[]{this.group}).order("-priority").order("id").fetch();
            log.debug("Total root menus: {}", (Object)menuList.size());
            this.generateMenuGraph(menuList);
            CsvTool.csvWriter((String)objectFile.getParent(), (String)objectFile.getName(), (char)';', (String[])this.csvHeaders, this.fieldDataList);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void generateMenuGraph(List<? extends MetaMenu> menuList) {
        for (MetaMenu metaMenu : menuList) {
            String model;
            String string = model = metaMenu.getAction() != null ? metaMenu.getAction().getModel() : null;
            if (model != null && !this.objectList.contains(model)) {
                this.updateFieldData(metaMenu.getAction());
            }
            List childList = ((MetaMenuRepository)Beans.get(MetaMenuRepository.class)).all().filter("self.parent = ?1 AND self.left = true", new Object[]{metaMenu}).order("-priority").order("id").fetch();
            this.generateMenuGraph(childList);
        }
    }

    private void updateFieldData(MetaAction action) {
        String[] objectName = action.getModel().split("\\.");
        String objName = objectName[objectName.length - 1];
        Map moduleMap = (Map)this.objectMap.get(objName);
        if (moduleMap == null) {
            return;
        }
        boolean addObject = true;
        MetaTranslationRepository metaTranslationRepo = (MetaTranslationRepository)Beans.get(MetaTranslationRepository.class);
        for (Map.Entry module : moduleMap.entrySet()) {
            boolean addModule = true;
            for (Map field : (List)module.getValue()) {
                String[] fields = new String[this.csvHeaders.length];
                fields[0] = "";
                if (addObject) {
                    fields[0] = action.getModel();
                    fields[8] = this.getActionUrl(action);
                }
                fields[1] = "";
                if (addModule) {
                    fields[1] = (String)module.getKey();
                }
                fields[2] = (String)field.get("name");
                fields[3] = (String)field.get("type");
                fields[4] = (String)field.get("title");
                MetaTranslation mts = metaTranslationRepo.findByKey((String)field.get("title"), "fr");
                if (mts != null) {
                    fields[5] = mts.getMessage();
                }
                if ((mts = metaTranslationRepo.findByKey("help:" + objName + "." + (String)field.get("name"), "en")) != null) {
                    fields[6] = mts.getMessage().replace(";", "\n");
                }
                if ((mts = metaTranslationRepo.findByKey("help:" + objName + "." + (String)field.get("name"), "fr")) != null) {
                    fields[7] = mts.getMessage().replace(";", "\n");
                }
                this.fieldDataList.add(fields);
                addObject = false;
                addModule = false;
            }
        }
        this.objectList.add(action.getModel());
    }

    private String getActionUrl(MetaAction action) {
        String url = AppSettings.get().getBaseURL() + "#/ds";
        String viewType = ExportDbObjectService.getActionViewType(action.getXml());
        if (viewType != null) {
            if (viewType.equals("grid")) {
                url = url + "/" + action.getName() + "/list/1";
            } else if (viewType.equals("form")) {
                url = url + "/" + action.getName() + "/edit";
            } else if (viewType.equals("calendar")) {
                url = url + "/" + action.getName() + "/calendar";
            }
        }
        return url;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getActionViewType(String xml) {
        DocumentBuilderFactory domFactory = ((XPathParse)Beans.get(XPathParse.class)).getDocumentBuilderFactory();
        domFactory.setNamespaceAware(true);
        try {
            DocumentBuilder builder = domFactory.newDocumentBuilder();
            File tempXml = File.createTempFile("Temp", "xml");
            try (FileWriter fw = new FileWriter(tempXml);){
                fw.write(xml);
                Document doc = builder.parse(new FileInputStream(tempXml));
                Node child = doc.getFirstChild();
                NodeList chs = child.getChildNodes();
                Integer i = 0;
                while (i < chs.getLength()) {
                    Object object;
                    if (chs.item(i).getNodeName().equals("view")) {
                        NamedNodeMap attributes = chs.item(i).getAttributes();
                        object = attributes.getNamedItem("type").getNodeValue();
                        return object;
                    }
                    Integer n = i;
                    i = i + 1;
                    object = i;
                }
                String string = "";
                return string;
            }
        }
        catch (Exception e) {
            log.error(e.getMessage());
            return null;
        }
    }

    private void updateObjectMap(List<File> modules, SAXParser parser, XmlHandler xmlHandler) throws SAXException, IOException {
        for (File module : modules) {
            String modulePath = module.getAbsolutePath();
            File modelDir = new File(modulePath + "/src/main/resources/domains/");
            if (!modelDir.exists()) continue;
            for (File objectFile : modelDir.listFiles()) {
                String objectName = objectFile.getName().split("\\.")[0];
                parser.parse(new InputSource(new FileInputStream(objectFile)), (DefaultHandler)xmlHandler);
                HashMap<String, Object> moduleMap = (HashMap<String, Object>)this.objectMap.get(objectName);
                if (moduleMap == null) {
                    moduleMap = new HashMap<String, Object>();
                }
                moduleMap.put(module.getName(), this.updateObjectModel(xmlHandler.fieldList, objectName, module.getName()));
                this.objectMap.put(objectName, moduleMap);
            }
        }
    }

    private Object updateObjectModel(List<Map<String, String>> fieldList, String objectName, String moduleName) {
        for (Map<String, String> field : fieldList) {
            field.put("module", moduleName);
            field.put("object", objectName);
        }
        return fieldList;
    }
}

