/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.administration;

import com.axelor.apps.base.db.IndicatorGenerator;
import com.axelor.apps.base.db.IndicatorGeneratorGrouping;
import com.axelor.apps.base.db.repo.IndicatorGeneratorGroupingRepository;
import com.axelor.apps.base.service.administration.IndicatorGeneratorService;
import com.axelor.apps.tool.file.CsvTool;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.IOException;
import java.util.ArrayList;

public class IndicatorGeneratorGroupingService {
    @Inject
    private IndicatorGeneratorService indicatorGeneratorService;
    @Inject
    private IndicatorGeneratorGroupingRepository iggRepo;

    @Transactional(rollbackOn={Exception.class})
    public void run(IndicatorGeneratorGrouping indicatorGeneratorGrouping) throws AxelorException {
        String log = "";
        String result = "";
        for (IndicatorGenerator indicatorGenerator : indicatorGeneratorGrouping.getIndicatorGeneratorSet()) {
            this.indicatorGeneratorService.run(indicatorGenerator);
            result = result + "\n" + indicatorGenerator.getCode() + " " + indicatorGenerator.getName() + " : " + indicatorGenerator.getResult();
            if (indicatorGenerator.getLog() == null || indicatorGenerator.getLog().isEmpty()) continue;
            log = log + "\n" + indicatorGenerator.getLog();
        }
        indicatorGeneratorGrouping.setResult(result);
        indicatorGeneratorGrouping.setLog(log);
        this.iggRepo.save((Model)((Object)indicatorGeneratorGrouping));
    }

    @Transactional(rollbackOn={Exception.class})
    public void export(IndicatorGeneratorGrouping indicatorGeneratorGrouping) throws AxelorException {
        String log = "";
        if (indicatorGeneratorGrouping.getPath() == null || indicatorGeneratorGrouping.getPath().isEmpty()) {
            log = log + "\n" + I18n.get((String)"Error : no export path has been set");
        }
        if (indicatorGeneratorGrouping.getCode() == null || indicatorGeneratorGrouping.getCode().isEmpty()) {
            log = log + "\n" + I18n.get((String)"Error : no code has been set");
        }
        ArrayList<String[]> resultList = new ArrayList<String[]>();
        for (IndicatorGenerator indicatorGenerator : indicatorGeneratorGrouping.getIndicatorGeneratorSet()) {
            String[] result = new String[]{indicatorGenerator.getCode(), indicatorGenerator.getName(), indicatorGenerator.getResult()};
            resultList.add(result);
            log = log + "\n" + indicatorGenerator.getLog();
        }
        try {
            CsvTool.csvWriter((String)indicatorGeneratorGrouping.getPath(), (String)(indicatorGeneratorGrouping.getCode() + ".csv"), (char)';', null, resultList);
        }
        catch (IOException e) {
            log = log + I18n.get((String)"Error while creating the file");
        }
        if (!log.isEmpty() && log.length() != 0) {
            String log2 = indicatorGeneratorGrouping.getLog();
            log2 = log2 + "\n ---------------------------------------------------";
            log2 = log2 + log;
            indicatorGeneratorGrouping.setLog(log2);
        }
        this.iggRepo.save((Model)((Object)indicatorGeneratorGrouping));
    }
}

