/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.administration;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Sequence;
import com.axelor.apps.base.db.SequenceLettersTypeSelect;
import com.axelor.apps.base.db.SequenceTypeSelect;
import com.axelor.apps.base.db.SequenceVersion;
import com.axelor.apps.base.db.repo.SequenceRepository;
import com.axelor.apps.base.db.repo.SequenceVersionRepository;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.tool.StringTool;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.db.MetaSelectItem;
import com.axelor.meta.db.repo.MetaSelectItemRepository;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.IsoFields;
import javax.annotation.concurrent.ThreadSafe;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@ThreadSafe
public class SequenceService {
    private static final String DRAFT_PREFIX = "#";
    private static final String PATTERN_FULL_YEAR = "%YYYY";
    private static final String PATTERN_YEAR = "%YY";
    private static final String PATTERN_MONTH = "%M";
    private static final String PATTERN_FULL_MONTH = "%FM";
    private static final String PATTERN_DAY = "%D";
    private static final String PATTERN_WEEK = "%WY";
    private static final String PADDING_STRING = "0";
    private final Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private SequenceVersionRepository sequenceVersionRepository;
    private AppBaseService appBaseService;
    @Inject
    private SequenceRepository sequenceRepo;

    @Inject
    public SequenceService(SequenceVersionRepository sequenceVersionRepository, AppBaseService appBaseService) {
        this.sequenceVersionRepository = sequenceVersionRepository;
        this.appBaseService = appBaseService;
    }

    public static boolean isYearValid(Sequence sequence) {
        boolean yearlyResetOk = sequence.getYearlyResetOk();
        if (!yearlyResetOk) {
            return true;
        }
        String seqPrefixe = StringUtils.defaultString((String)sequence.getPrefixe(), (String)"");
        String seqSuffixe = StringUtils.defaultString((String)sequence.getSuffixe(), (String)"");
        String seq = seqPrefixe + seqSuffixe;
        return !yearlyResetOk || seq.contains(PATTERN_YEAR) || seq.contains(PATTERN_FULL_YEAR);
    }

    public static boolean isMonthValid(Sequence sequence) {
        boolean monthlyResetOk = sequence.getMonthlyResetOk();
        if (!monthlyResetOk) {
            return true;
        }
        String seqPrefixe = StringUtils.defaultString((String)sequence.getPrefixe(), (String)"");
        String seqSuffixe = StringUtils.defaultString((String)sequence.getSuffixe(), (String)"");
        String seq = seqPrefixe + seqSuffixe;
        return !monthlyResetOk || (seq.contains(PATTERN_MONTH) || seq.contains(PATTERN_FULL_MONTH)) && (seq.contains(PATTERN_YEAR) || seq.contains(PATTERN_FULL_YEAR));
    }

    public static boolean isSequenceLengthValid(Sequence sequence) {
        String seqPrefixe = StringUtils.defaultString((String)sequence.getPrefixe(), (String)"").replaceAll("%", "");
        String seqSuffixe = StringUtils.defaultString((String)sequence.getSuffixe(), (String)"").replaceAll("%", "");
        return seqPrefixe.length() + seqSuffixe.length() + sequence.getPadding() <= 14;
    }

    public Sequence getSequence(String code, Company company) {
        if (code == null) {
            return null;
        }
        if (company == null) {
            return this.sequenceRepo.findByCode(code);
        }
        return this.sequenceRepo.find(code, company);
    }

    public String getSequenceNumber(String code) {
        return this.getSequenceNumber(code, null);
    }

    public String getSequenceNumber(String code, Company company) {
        Sequence sequence = this.getSequence(code, company);
        if (sequence == null) {
            return null;
        }
        return this.getSequenceNumber(sequence, this.appBaseService.getTodayDate(company));
    }

    public boolean hasSequence(String code, Company company) {
        return this.getSequence(code, company) != null;
    }

    public String getSequenceNumber(Sequence sequence) {
        return this.getSequenceNumber(sequence, this.appBaseService.getTodayDate(sequence.getCompany()));
    }

    @Transactional
    public String getSequenceNumber(Sequence sequence, LocalDate refDate) {
        SequenceVersion sequenceVersion = this.getVersion(sequence, refDate);
        String seqPrefixe = StringUtils.defaultString((String)sequence.getPrefixe(), (String)"");
        String seqSuffixe = StringUtils.defaultString((String)sequence.getSuffixe(), (String)"");
        String sequenceValue = sequence.getSequenceTypeSelect() == SequenceTypeSelect.NUMBERS ? StringUtils.leftPad((String)sequenceVersion.getNextNum().toString(), (int)sequence.getPadding(), (String)PADDING_STRING) : this.findNextLetterSequence(sequenceVersion);
        sequenceVersion.setNextNum(sequenceVersion.getNextNum() + (long)sequence.getToBeAdded().intValue());
        String nextSeq = (seqPrefixe + sequenceValue + seqSuffixe).replaceAll(PATTERN_FULL_YEAR, Integer.toString(refDate.get(ChronoField.YEAR_OF_ERA))).replaceAll(PATTERN_YEAR, refDate.format(DateTimeFormatter.ofPattern("yy"))).replaceAll(PATTERN_MONTH, Integer.toString(refDate.getMonthValue())).replaceAll(PATTERN_FULL_MONTH, refDate.format(DateTimeFormatter.ofPattern("MM"))).replaceAll(PATTERN_DAY, Integer.toString(refDate.getDayOfMonth())).replaceAll(PATTERN_WEEK, Integer.toString(refDate.get(IsoFields.WEEK_OF_WEEK_BASED_YEAR)));
        this.log.debug("nextSeq : : : : {}", (Object)nextSeq);
        this.sequenceVersionRepository.save((Model)((Object)sequenceVersion));
        return nextSeq;
    }

    private String findNextLetterSequence(SequenceVersion sequenceVersion) {
        long n = sequenceVersion.getNextNum();
        char[] buf = new char[(int)Math.floor(Math.log(25L * (n + 1L)) / Math.log(26.0))];
        for (int i = buf.length - 1; i >= 0; --i) {
            buf[i] = (char)(65L + --n % 26L);
            n /= 26L;
        }
        if (sequenceVersion.getSequence().getSequenceLettersTypeSelect() == SequenceLettersTypeSelect.UPPERCASE) {
            return new String(buf);
        }
        return new String(buf).toLowerCase();
    }

    protected SequenceVersion getVersion(Sequence sequence, LocalDate refDate) {
        this.log.debug("Reference date : : : : {}", (Object)refDate);
        if (sequence.getMonthlyResetOk().booleanValue()) {
            return this.getVersionByMonth(sequence, refDate);
        }
        if (sequence.getYearlyResetOk().booleanValue()) {
            return this.getVersionByYear(sequence, refDate);
        }
        return this.getVersionByDate(sequence, refDate);
    }

    protected SequenceVersion getVersionByDate(Sequence sequence, LocalDate refDate) {
        SequenceVersion sequenceVersion = this.sequenceVersionRepository.findByDate(sequence, refDate);
        if (sequenceVersion == null) {
            sequenceVersion = new SequenceVersion(sequence, refDate, null, 1L);
        }
        return sequenceVersion;
    }

    protected SequenceVersion getVersionByMonth(Sequence sequence, LocalDate refDate) {
        SequenceVersion sequenceVersion = this.sequenceVersionRepository.findByMonth(sequence, refDate.getMonthValue(), refDate.getYear());
        if (sequenceVersion == null) {
            sequenceVersion = new SequenceVersion(sequence, refDate.withDayOfMonth(1), refDate.withDayOfMonth(refDate.lengthOfMonth()), 1L);
        }
        return sequenceVersion;
    }

    protected SequenceVersion getVersionByYear(Sequence sequence, LocalDate refDate) {
        SequenceVersion sequenceVersion = this.sequenceVersionRepository.findByYear(sequence, refDate.getYear());
        if (sequenceVersion == null) {
            sequenceVersion = new SequenceVersion(sequence, refDate.withDayOfMonth(1), refDate.withDayOfMonth(refDate.lengthOfMonth()), 1L);
        }
        return sequenceVersion;
    }

    public String getDefaultTitle(Sequence sequence) {
        MetaSelectItem item = (MetaSelectItem)((MetaSelectItemRepository)Beans.get(MetaSelectItemRepository.class)).all().filter("self.select.name = ? AND self.value = ?", new Object[]{"sequence.generic.code.select", sequence.getCode()}).fetchOne();
        return item.getTitle();
    }

    public String getDraftSequenceNumber(Model model) throws AxelorException {
        if (model.getId() == null) {
            throw new AxelorException(model, 5, I18n.get((String)"Can't generate draft sequence number on an unsaved record."));
        }
        return String.format("%s%d", DRAFT_PREFIX, model.getId());
    }

    public String getDraftSequenceNumber(Model model, int zeroPadding) throws AxelorException {
        if (model.getId() == null) {
            throw new AxelorException(model, 5, I18n.get((String)"Can't generate draft sequence number on an unsaved record."));
        }
        return String.format("%s%s", DRAFT_PREFIX, StringTool.fillStringLeft((String)String.valueOf(model.getId()), (char)'0', (int)zeroPadding));
    }

    public boolean isEmptyOrDraftSequenceNumber(String sequenceNumber) {
        return Strings.isNullOrEmpty((String)sequenceNumber) || sequenceNumber.matches(String.format("[\\%s\\*]\\d+", DRAFT_PREFIX));
    }

    public String computeFullName(Sequence sequence) {
        StringBuilder fn = new StringBuilder();
        if (sequence.getPrefixe() != null) {
            fn.append(sequence.getPrefixe());
        }
        for (int i = 0; i < sequence.getPadding(); ++i) {
            fn.append("X");
        }
        if (sequence.getSuffixe() != null) {
            fn.append(sequence.getSuffixe());
        }
        fn.append(" - ");
        fn.append(sequence.getName());
        return fn.toString();
    }
}

