/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.advanced.imports;

import com.axelor.apps.base.service.advanced.imports.ActionService;
import com.axelor.common.ObjectUtils;
import com.axelor.common.StringUtils;
import com.axelor.db.EntityHelper;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.meta.ActionExecutor;
import com.axelor.meta.ActionHandler;
import com.axelor.meta.MetaStore;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.ContextEntity;
import com.axelor.rpc.ContextHandlerFactory;
import com.axelor.rpc.Resource;
import com.google.inject.Inject;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

public class ActionServiceImpl
implements ActionService {
    @Inject
    protected ActionExecutor executor;
    private String modelName;
    private Map<String, Object> context;

    @Override
    public Boolean validate(String actions) {
        if (StringUtils.isBlank((CharSequence)actions)) {
            return false;
        }
        List<String> actionNameList = Arrays.asList(actions.split("\\,"));
        if (ObjectUtils.isEmpty(actionNameList)) {
            return false;
        }
        return !actionNameList.stream().anyMatch(name -> MetaStore.getAction((String)name) == null);
    }

    @Override
    public Object apply(String actions, Object bean) {
        if (StringUtils.isBlank((CharSequence)actions) || bean == null) {
            return bean;
        }
        Class<?> klass = bean.getClass();
        this.modelName = klass.getName();
        this.context = Mapper.toMap((Object)bean);
        this.apply(actions);
        return this.updateBean(bean);
    }

    protected void apply(String actions) {
        ActionResponse value;
        ActionHandler handler = this.createHandler(actions);
        ActionResponse response = value = handler.execute();
        List dataList = (List)response.getData();
        for (Map map : dataList) {
            this.updateContext(map);
        }
    }

    protected ActionHandler createHandler(String action) {
        ActionRequest request = new ActionRequest();
        HashMap<String, Map<String, Object>> data = new HashMap<String, Map<String, Object>>();
        request.setData(data);
        request.setModel(this.modelName);
        request.setAction(action);
        data.put("context", this.context);
        return this.executor.newActionHandler(request);
    }

    private void updateContext(Map<String, Object> value) {
        if (value == null) {
            return;
        }
        Object values = value.get("values");
        Map map = new HashMap();
        if (values instanceof ContextEntity) {
            map = ((ContextEntity)values).getContextMap();
        } else if (values instanceof Model) {
            map = Mapper.toMap(value);
        } else if (values instanceof Map) {
            map = (Map)values;
        }
        values = value.get("attrs");
        if (values instanceof Map) {
            for (Object key : ((Map)values).keySet()) {
                String name = key.toString();
                Map attrs = (Map)((Map)values).get(key);
                if (attrs.containsKey("value")) {
                    map.put(name, attrs.get("value"));
                }
                if (!attrs.containsKey("value:set")) continue;
                map.put(name, attrs.get("value:set"));
            }
        }
        this.context.putAll(map);
    }

    protected <T extends Model> Object updateBean(Object bean) {
        Class klass = JPA.model((String)this.modelName);
        Model updatedBean = (Model)Mapper.toBean((Class)klass, this.context);
        for (Property property : JPA.fields((Class)klass)) {
            Object oldValue = property.get(bean);
            Object newValue = property.get((Object)updatedBean);
            if (ObjectUtils.isEmpty((Object)newValue) || !property.valueChanged((Object)updatedBean, oldValue)) continue;
            property.set(bean, this.validate(property, newValue));
        }
        return bean;
    }

    protected Object validate(Property property, Object value) {
        if (property == null) {
            return value;
        }
        if (property.isCollection() && value instanceof Collection) {
            value = ((Collection)value).stream().map(item -> this.createOrFind(property, item)).collect(Collectors.toList());
        } else if (property.isReference()) {
            value = this.createOrFind(property, value);
        }
        return value;
    }

    protected Object createOrFind(Property property, Object item) {
        if (item == null) {
            return item;
        }
        Long id = ((Model)item).getId();
        if (id == null || id <= 0L) {
            return EntityHelper.getEntity((Object)ContextHandlerFactory.newHandler((Class)property.getTarget(), (Map)Resource.toMapCompact((Object)item)).getProxy());
        }
        Object bean = JPA.em().find(property.getTarget(), (Object)id);
        return bean;
    }
}

