/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.advanced.imports;

import com.axelor.apps.base.db.FileField;
import com.axelor.apps.base.service.advanced.imports.FileFieldService;
import com.axelor.meta.db.MetaField;
import com.axelor.meta.db.MetaModel;
import com.axelor.meta.db.repo.MetaFieldRepository;
import com.axelor.meta.db.repo.MetaModelRepository;
import com.google.common.base.Strings;
import com.google.inject.Inject;

public class FileFieldServiceImpl
implements FileFieldService {
    @Inject
    private MetaModelRepository metaModelRepo;
    @Inject
    MetaFieldRepository metaFieldRepo;

    @Override
    public FileField fillType(FileField fileField) {
        String targetType = null;
        String relationship = null;
        if (fileField.getImportField() != null) {
            targetType = fileField.getImportField().getTypeName();
            relationship = fileField.getImportField().getRelationship();
            if (!Strings.isNullOrEmpty((String)fileField.getSubImportField())) {
                String[] subFields = fileField.getSubImportField().split("\\.");
                String[] types = this.getSubFieldType(subFields, 0, fileField.getImportField());
                targetType = types[0];
                relationship = types[1];
            }
        }
        fileField.setTargetType(targetType);
        fileField.setRelationship(relationship);
        return fileField;
    }

    private String[] getSubFieldType(String[] subFields, int index, MetaField parentField) {
        String[] types = new String[2];
        if (index < subFields.length) {
            types[0] = parentField.getTypeName();
            types[1] = parentField.getRelationship();
            MetaModel childModel = this.metaModelRepo.findByName(parentField.getTypeName());
            if (childModel != null) {
                MetaField childField = this.metaFieldRepo.findByModel(subFields[index], childModel);
                if (childField == null) {
                    return types;
                }
                if (childField.getRelationship() != null) {
                    if (!types[0].equals("MetaFile")) {
                        types[0] = childField.getTypeName();
                    }
                    types[1] = childField.getRelationship();
                    types = this.getSubFieldType(subFields, index + 1, childField);
                } else if (!types[0].equals("MetaFile")) {
                    types[0] = childField.getTypeName();
                }
            }
        } else {
            if (!Strings.isNullOrEmpty((String)types[0]) && !types[0].equals("MetaFile") || Strings.isNullOrEmpty((String)types[0])) {
                types[0] = parentField.getTypeName();
            }
            types[1] = parentField.getRelationship();
        }
        return types;
    }

    @Override
    public String computeFullName(FileField fileField) {
        String fullName = fileField.getSequence().toString();
        if (!Strings.isNullOrEmpty((String)fileField.getColumnTitle())) {
            fullName = fullName + " - " + fileField.getColumnTitle();
        }
        if (fileField.getImportField() != null) {
            fullName = fullName + " - " + fileField.getImportField().getName();
        }
        if (!Strings.isNullOrEmpty((String)fileField.getSubImportField())) {
            fullName = fullName + "." + fileField.getSubImportField();
        }
        return fullName;
    }
}

