/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.advancedExport;

import com.axelor.apps.base.db.AdvancedExport;
import com.axelor.exception.AxelorException;
import java.io.File;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.persistence.Query;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AdvancedExportGenerator {
    private final Logger log = LoggerFactory.getLogger(AdvancedExportGenerator.class);
    private boolean isReachMaxExportLimit;

    public abstract void generateHeader() throws AxelorException;

    public abstract void generateBody(List<List> var1);

    public abstract void close() throws AxelorException;

    public abstract AdvancedExport getAdvancedExport();

    public abstract File getExportFile();

    public abstract String getFileName();

    public File generateFile(Query query) throws AxelorException {
        AdvancedExport advancedExport = this.getAdvancedExport();
        this.log.debug("Export file : {}", (Object)this.getFileName());
        this.generateHeader();
        int startPosition = 0;
        int reachLimit = 0;
        int maxExportLimit = advancedExport.getMaxExportLimit();
        int queryFetchLimit = advancedExport.getQueryFetchSize();
        List<List> dataList = new ArrayList();
        query.setMaxResults(queryFetchLimit);
        while (startPosition < maxExportLimit) {
            if (maxExportLimit - startPosition < queryFetchLimit) {
                query.setMaxResults(maxExportLimit - startPosition);
            }
            query.setFirstResult(startPosition);
            dataList = query.getResultList();
            if (dataList.isEmpty()) break;
            this.generateBody(dataList);
            startPosition += queryFetchLimit;
            reachLimit += dataList.size();
        }
        if (maxExportLimit == reachLimit) {
            this.isReachMaxExportLimit = true;
        }
        this.close();
        return this.getExportFile();
    }

    public boolean getIsReachMaxExportLimit() {
        return this.isReachMaxExportLimit;
    }

    public String getExportFileName() {
        return this.getFileName();
    }

    public String convertDecimalValue(Object value) {
        BigDecimal decimalVal = (BigDecimal)value;
        return String.format("%." + decimalVal.scale() + "f", decimalVal);
    }
}

