/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.alarm;

import com.axelor.apps.base.db.Alarm;
import com.axelor.apps.base.db.AlarmEngine;
import com.axelor.apps.base.db.repo.AlarmRepository;
import com.axelor.apps.base.service.administration.AbstractBatch;
import com.axelor.apps.base.service.alarm.AlarmEngineService;
import com.axelor.db.EntityHelper;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.lang.reflect.Field;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmEngineBatchService
extends AbstractBatch {
    static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected AlarmEngineService<Model> alarmEngineService;
    protected AlarmRepository alarmRepo;

    @Inject
    public AlarmEngineBatchService(AlarmEngineService<Model> alarmEngineService, AlarmRepository alarmRepo) {
        this.alarmEngineService = alarmEngineService;
        this.alarmRepo = alarmRepo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void process() {
        for (AlarmEngine alarmEngine : this.batch.getAlarmEngineBatch().getAlarmEngineSet()) {
            try {
                this.persistAlarm(this.alarmEngineService.get(alarmEngine, Class.forName(alarmEngine.getMetaModel().getFullName()), new Model[0]));
            }
            catch (Exception e) {
                TraceBackService.trace((Throwable)new Exception(String.format(I18n.get((String)"Alarm Engine %s"), alarmEngine.getCode()), e), (String)"", (long)this.batch.getId());
                this.incrementAnomaly();
            }
            finally {
                JPA.clear();
            }
        }
    }

    @Override
    protected void stop() {
        String comment = I18n.get((String)"Alarms report :") + "\n";
        comment = comment + String.format("\t" + I18n.get((String)"* %s object(s) into alarm") + "\n", this.batch.getDone());
        comment = comment + String.format("\t" + I18n.get((String)"* %s anomaly(ies)"), this.batch.getAnomaly());
        super.stop();
        this.addComment(comment);
    }

    @Transactional(rollbackOn={Exception.class})
    protected <T extends Model> void persistAlarm(Map<T, Alarm> alarms) throws IllegalArgumentException, IllegalAccessException {
        Alarm alarm = null;
        for (Model t : alarms.keySet()) {
            alarm = alarms.get(t);
            this.associateAlarm(alarm, t);
            this.alarmRepo.save((Model)((Object)alarm));
            this.incrementDone();
        }
    }

    private <T extends Model> void associateAlarm(Alarm alarm, T t) throws IllegalArgumentException, IllegalAccessException {
        LOG.debug("ASSOCIATE alarm:{} TO model:{}", new Object[]{this.batch, this.model});
        for (Field field : ((Object)((Object)alarm)).getClass().getDeclaredFields()) {
            LOG.debug("TRY TO ASSOCIATE field:{} TO model:{}", new Object[]{field.getType().getName(), t.getClass().getName()});
            if (!this.isAssociable(field, t)) continue;
            LOG.debug("FIELD ASSOCIATE TO MODEL");
            field.setAccessible(true);
            field.set((Object)alarm, t);
            field.setAccessible(false);
            break;
        }
    }

    private <T extends Model> boolean isAssociable(Field field, T t) {
        return field.getType().equals(EntityHelper.getEntityClass(t));
    }
}

