/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.alarm;

import com.axelor.apps.base.db.Alarm;
import com.axelor.apps.base.db.AlarmEngine;
import com.axelor.apps.base.db.AlarmMessage;
import com.axelor.apps.base.db.repo.AlarmEngineRepository;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.db.mapper.Mapper;
import com.axelor.meta.service.MetaModelService;
import com.axelor.text.Templates;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AlarmEngineService<T extends Model> {
    protected AppBaseService appBaseService;
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Templates templates;
    @Inject
    private AlarmEngineRepository alarmEngineRepo;

    @Inject
    public AlarmEngineService(AppBaseService appBaseService) {
        this.appBaseService = appBaseService;
    }

    public Alarm get(String alarmEngineCode, T t, boolean isExternal) {
        AlarmEngine alarmEngine = (AlarmEngine)((Object)this.alarmEngineRepo.all().filter("self.code = ?1 AND externalOk = ?2 AND activeOk = true", new Object[]{alarmEngineCode, isExternal}).fetchOne());
        if (alarmEngine != null) {
            return this.createAlarm(alarmEngine, t);
        }
        return null;
    }

    public Map<T, List<Alarm>> get(Class<T> klass, T ... params) {
        List alarmEngines = this.alarmEngineRepo.all().filter("metaModel = ?1 AND activeOk = true AND externalOk = false", new Object[]{MetaModelService.getMetaModel(klass)}).fetch();
        LOG.debug("Lancement des moteurs de type {} : {} moteurs \u00e0 lancer", klass, (Object)alarmEngines.size());
        return this.get(alarmEngines, klass, (Model[])params);
    }

    protected Map<T, List<Alarm>> get(List<? extends AlarmEngine> alarmEngines, Class<T> klass, T ... params) {
        HashMap map = new HashMap();
        HashMap alarmMap = new HashMap();
        for (AlarmEngine alarmEngine : alarmEngines) {
            alarmMap.clear();
            alarmMap.putAll(this.get(alarmEngine, klass, (Model[])params));
            for (Model t : alarmMap.keySet()) {
                if (!map.containsKey(t)) {
                    map.put(t, new ArrayList());
                }
                ((List)map.get(t)).add(alarmMap.get(t));
            }
        }
        return map;
    }

    protected Map<T, Alarm> get(AlarmEngine alarmEngine, Class<T> klass, T ... params) {
        HashMap<Model, Alarm> map = new HashMap<Model, Alarm>();
        for (Model t : this.results(alarmEngine.getQuery(), klass, (Model[])params)) {
            if (map.containsKey(t)) continue;
            map.put(t, this.createAlarm(alarmEngine, t));
        }
        LOG.debug("{} objets en alarmes", (Object)map.size());
        return map;
    }

    public List<T> results(String query, Class<T> klass, T ... params) {
        LOG.debug("Lancement de la requ\u00eate {} => Objet: {}, params: {}", new Object[]{query, klass.getSimpleName(), params});
        if (params != null && params.length > 0) {
            String query2 = String.format("self in ?1 AND (%s)", query);
            return JPA.all(klass).filter(query2, new Object[]{Arrays.asList(params)}).fetch();
        }
        return JPA.all(klass).filter(query).fetch();
    }

    public Alarm createAlarm(AlarmEngine alarmEngine, T t) {
        Alarm alarm = new Alarm();
        alarm.setDate(this.appBaseService.getTodayDateTime());
        alarm.setAlarmEngine(alarmEngine);
        alarm.setContent(this.content(alarmEngine.getAlarmMessage(), t));
        if (alarm.getAlarmEngine().getLockingOk().booleanValue()) {
            alarm.setAcquitOk(false);
        } else {
            alarm.setAcquitOk(true);
        }
        return alarm;
    }

    protected String content(AlarmMessage alarmMessage, T t) {
        return this.templates.fromText(alarmMessage.getMessage()).make(Mapper.toMap(t)).render();
    }
}

