/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.app;

import com.axelor.app.AppSettings;
import com.axelor.apps.base.db.AppBase;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.CurrencyConversionLine;
import com.axelor.apps.base.db.Language;
import com.axelor.apps.base.db.Unit;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.base.service.app.AppServiceImpl;
import com.axelor.apps.tool.date.DateTool;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.Query;
import com.google.common.base.Strings;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.time.LocalDate;
import java.time.ZonedDateTime;
import java.util.List;
import javax.inject.Singleton;

@Singleton
public class AppBaseServiceImpl
extends AppServiceImpl
implements AppBaseService {
    protected static String DEFAULT_LOCALE = "en";

    @Override
    public AppBase getAppBase() {
        return (AppBase)((Object)Query.of(AppBase.class).cacheable().fetchOne());
    }

    @Override
    public ZonedDateTime getTodayDateTime() {
        return this.getTodayDateTime(null);
    }

    @Override
    public ZonedDateTime getTodayDateTime(Company company) {
        String applicationMode;
        ZonedDateTime todayDateTime = ZonedDateTime.now();
        if (company != null) {
            todayDateTime = DateTool.getTodayDateTime((String)company.getTimezone());
        }
        if ("dev".equals(applicationMode = AppSettings.get().get("application.mode", "prod"))) {
            User user = AuthUtils.getUser();
            if (user != null && user.getToday() != null) {
                todayDateTime = user.getToday();
            } else {
                AppBase appBase = this.getAppBase();
                if (appBase != null && appBase.getToday() != null) {
                    return appBase.getToday();
                }
            }
        }
        return todayDateTime;
    }

    @Override
    public LocalDate getTodayDate() {
        return this.getTodayDateTime().toLocalDate();
    }

    @Override
    public LocalDate getTodayDate(Company company) {
        return this.getTodayDateTime(company).toLocalDate();
    }

    @Override
    public Unit getUnit() {
        AppBase appBase = this.getAppBase();
        if (appBase != null) {
            return appBase.getDefaultProjectUnit();
        }
        return null;
    }

    @Override
    public int getNbDecimalDigitForUnitPrice() {
        AppBase appBase = this.getAppBase();
        if (appBase != null) {
            return appBase.getNbDecimalDigitForUnitPrice();
        }
        return 2;
    }

    @Override
    public int getGlobalTrackingLogPersistence() {
        AppBase appBase = this.getAppBase();
        if (appBase != null) {
            return appBase.getGlobalTrackingLogPersistence();
        }
        return 1;
    }

    @Override
    public int getNbDecimalDigitForQty() {
        AppBase appBase = this.getAppBase();
        if (appBase != null) {
            return appBase.getNbDecimalDigitForQty();
        }
        return 2;
    }

    @Override
    public String getDefaultPartnerLanguageCode() {
        Language language;
        AppBase appBase = this.getAppBase();
        if (appBase != null && (language = appBase.getDefaultPartnerLanguage()) != null && !Strings.isNullOrEmpty((String)language.getCode())) {
            return language.getCode();
        }
        return DEFAULT_LOCALE;
    }

    @Override
    public List<CurrencyConversionLine> getCurrencyConfigurationLineList() {
        AppBase appBase = this.getAppBase();
        if (appBase != null) {
            return appBase.getCurrencyConversionLineList();
        }
        return null;
    }

    @Override
    public BigDecimal getDurationHours(BigDecimal duration) {
        if (duration == null) {
            return null;
        }
        AppBase appBase = this.getAppBase();
        if (appBase != null) {
            String timePref = appBase.getTimeLoggingPreferenceSelect();
            if (timePref.equals("days")) {
                duration = duration.multiply(appBase.getDailyWorkHours());
            } else if (timePref.equals("minutes")) {
                duration = duration.divide(new BigDecimal(60), 2, RoundingMode.HALF_EVEN);
            }
        }
        return duration;
    }

    @Override
    public BigDecimal getGeneralDuration(BigDecimal duration) {
        if (duration == null) {
            return null;
        }
        AppBase appBase = this.getAppBase();
        if (appBase != null) {
            String timePref = appBase.getTimeLoggingPreferenceSelect();
            BigDecimal dailyWorkHrs = appBase.getDailyWorkHours();
            if (timePref.equals("days") && dailyWorkHrs != null && dailyWorkHrs.compareTo(BigDecimal.ZERO) != 0) {
                duration = duration.divide(dailyWorkHrs, 2, RoundingMode.HALF_EVEN);
            } else if (timePref.equals("minutes")) {
                duration = duration.multiply(new BigDecimal(60));
            }
        }
        return duration;
    }

    @Override
    @Transactional
    public void setManageMultiBanks(boolean manageMultiBanks) {
        this.getAppBase().setManageMultiBanks(manageMultiBanks);
    }
}

