/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.imports;

import com.axelor.apps.base.service.imports.ConvertDemoDataFileService;
import com.axelor.apps.base.service.imports.importer.ExcelToCSV;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.google.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ConvertDemoDataFileServiceImpl
implements ConvertDemoDataFileService {
    @Inject
    private ExcelToCSV excelToCSV;
    @Inject
    private MetaFiles metaFiles;

    @Override
    public MetaFile convertDemoDataExcelFile(File excelFile) throws IOException, AxelorException, ParseException {
        File zipFile = this.createZIPFromExcel(excelFile);
        FileInputStream inStream = new FileInputStream(zipFile);
        MetaFile metaFile = this.metaFiles.upload((InputStream)inStream, "demo_data_" + new SimpleDateFormat("ddMMyyyHHmm").format(new Date()) + ".zip");
        inStream.close();
        zipFile.delete();
        return metaFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File createZIPFromExcel(File excelFile) throws IOException, ParseException, AxelorException {
        XSSFWorkbook workBook = new XSSFWorkbook((InputStream)new FileInputStream(excelFile));
        File zipFile = File.createTempFile("demo", ".zip");
        ArrayList<String> entries = new ArrayList<String>();
        for (int i = 0; i < workBook.getNumberOfSheets(); ++i) {
            Sheet sheet = workBook.getSheetAt(i);
            File csvFile = new File(excelFile.getParent() + File.separator + this.getFileNameFromSheet(sheet));
            try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(zipFile));){
                this.excelToCSV.writeTOCSV(csvFile, sheet, 3, 1);
                if (entries.contains(csvFile.getName())) {
                    throw new AxelorException(5, I18n.get((String)"Please remove duplicate csv file name from excel file."));
                }
                entries.add(csvFile.getName());
                this.writeToZip(csvFile, zos);
                continue;
            }
            finally {
                csvFile.delete();
            }
        }
        entries.clear();
        return zipFile;
    }

    private void writeToZip(File csvFile, ZipOutputStream zos) throws IOException {
        try (FileInputStream fis = new FileInputStream(csvFile);){
            int length;
            zos.putNextEntry(new ZipEntry(csvFile.getName()));
            byte[] buffer = new byte[1024];
            while ((length = fis.read(buffer)) > 0) {
                zos.write(buffer, 0, length);
            }
            zos.closeEntry();
        }
    }

    private String getFileNameFromSheet(Sheet sheet) throws AxelorException {
        Cell fileNameCell;
        String fileName = "";
        Row fileNameRow = sheet.getRow(1);
        if (fileNameRow != null) {
            fileNameCell = fileNameRow.getCell(0);
            if (fileNameCell == null || fileNameCell.getCellType() == 3 || fileNameCell.getCellType() != 1) {
                throw new AxelorException(1, I18n.get((String)"Please provide valid csv file name."));
            }
        } else {
            throw new AxelorException(5, I18n.get((String)"Improper format of excel file."));
        }
        fileName = fileNameCell.getStringCellValue() + ".csv";
        return fileName;
    }
}

