/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.imports;

import com.axelor.apps.base.db.ImportConfiguration;
import com.axelor.apps.base.db.ImportHistory;
import com.axelor.apps.base.service.imports.ImportCityService;
import com.axelor.apps.base.service.imports.importer.FactoryImporter;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.google.common.io.Files;
import com.google.inject.Inject;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.lang.invoke.MethodHandles;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportCityServiceImpl
implements ImportCityService {
    @Inject
    private FactoryImporter factoryImporter;
    @Inject
    private MetaFiles metaFiles;
    public static String CITYTEXTFILE = "cityTextFile.txt";
    public static String DOWNLOAD_LINK = "http://download.geonames.org/export/zip/";
    final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public ImportHistory importCity(String typeSelect, MetaFile dataFile) {
        ImportHistory importHistory = null;
        try {
            if (dataFile.getFileType().equals("application/zip")) {
                dataFile = this.extractCityZip(dataFile);
            }
            File configXmlFile = this.getConfigXmlFile(typeSelect);
            File dataCsvFile = this.getDataCsvFile(dataFile);
            importHistory = this.importCityData(configXmlFile, dataCsvFile);
            this.deleteTempFiles(configXmlFile, dataCsvFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return importHistory;
    }

    private File getConfigXmlFile(String typeSelect) {
        File configFile = null;
        try {
            configFile = File.createTempFile("input-config", ".xml");
            InputStream bindFileInputStream = this.getClass().getResourceAsStream("/import-configs/" + typeSelect + "-config.xml");
            if (bindFileInputStream == null) {
                throw new AxelorException(4, I18n.get((String)"Error : Mapping file is not found."));
            }
            FileOutputStream outputStream = new FileOutputStream(configFile);
            IOUtils.copy((InputStream)bindFileInputStream, (OutputStream)outputStream);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return configFile;
    }

    private File getDataCsvFile(MetaFile dataFile) {
        File csvFile = null;
        try {
            File tempDir = Files.createTempDir();
            csvFile = new File(tempDir, "geonames_city.csv");
            Files.copy((File)MetaFiles.getPath((MetaFile)dataFile).toFile(), (File)csvFile);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return csvFile;
    }

    private ImportHistory importCityData(File configXmlFile, File dataCsvFile) {
        ImportHistory importHistory = null;
        try {
            ImportConfiguration importConfiguration = new ImportConfiguration();
            importConfiguration.setBindMetaFile(this.metaFiles.upload(configXmlFile));
            importConfiguration.setDataMetaFile(this.metaFiles.upload(dataCsvFile));
            importHistory = this.factoryImporter.createImporter(importConfiguration).run();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return importHistory;
    }

    private void deleteTempFiles(File configXmlFile, File dataCsvFile) {
        try {
            if (configXmlFile.isDirectory() && dataCsvFile.isDirectory()) {
                FileUtils.deleteDirectory((File)configXmlFile);
                FileUtils.deleteDirectory((File)dataCsvFile);
            } else {
                configXmlFile.delete();
                dataCsvFile.delete();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public MetaFile downloadZip(String downloadFileName) throws Exception {
        File downloadFile = null;
        File cityTextFile = null;
        File tempDir = null;
        MetaFile metaFile = null;
        try {
            tempDir = Files.createTempDir();
            downloadFile = new File(tempDir, downloadFileName);
            cityTextFile = new File(tempDir, CITYTEXTFILE);
            URL url = new URL(DOWNLOAD_LINK + downloadFileName);
            FileUtils.copyURLToFile((URL)url, (File)downloadFile);
            this.LOG.debug("path for downloaded zip file : " + downloadFile.getPath());
            try (ZipFile zipFile = new ZipFile(downloadFile.getPath());
                 FileWriter writer = new FileWriter(cityTextFile);){
                Enumeration<? extends ZipEntry> entries = zipFile.entries();
                while (entries.hasMoreElements()) {
                    String line;
                    ZipEntry entry = entries.nextElement();
                    if (!entry.getName().equals(downloadFileName.replace("zip", "txt"))) continue;
                    BufferedReader stream = new BufferedReader(new InputStreamReader(zipFile.getInputStream(entry)));
                    StringBuffer buffer = new StringBuffer();
                    while ((line = stream.readLine()) != null) {
                        buffer.append(line + "\n");
                    }
                    cityTextFile.createNewFile();
                    writer.flush();
                    writer.write(buffer.toString().replace("\"", ""));
                    this.LOG.debug("Length of file : " + cityTextFile.length());
                    break;
                }
            }
            metaFile = this.metaFiles.upload(cityTextFile);
            FileUtils.forceDelete((File)tempDir);
        }
        catch (UnknownHostException hostExp) {
            throw new Exception(I18n.get((String)"Unable to connect to Geonames server"), hostExp);
        }
        catch (Exception e) {
            throw e;
        }
        return metaFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MetaFile extractCityZip(MetaFile dataFile) throws Exception {
        ZipEntry entry = null;
        MetaFile metaFile = null;
        File txtFile = File.createTempFile("city", ".txt");
        String requiredFileName = dataFile.getFileName().replace(".zip", ".txt");
        byte[] buffer = new byte[1024];
        try (ZipInputStream zipFileInStream = new ZipInputStream(new FileInputStream(MetaFiles.getPath((MetaFile)dataFile).toFile()));){
            while ((entry = zipFileInStream.getNextEntry()) != null) {
                if (!entry.getName().equals(requiredFileName)) continue;
                try (FileOutputStream fos = new FileOutputStream(txtFile);){
                    int len;
                    while ((len = zipFileInStream.read(buffer)) > 0) {
                        fos.write(buffer, 0, len);
                    }
                    break;
                }
            }
        }
        metaFile = this.metaFiles.upload(txtFile);
        FileUtils.forceDelete((File)txtFile);
        return metaFile;
    }
}

