/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.imports;

import com.axelor.apps.base.db.ImportConfiguration;
import com.axelor.apps.base.db.ImportHistory;
import com.axelor.apps.base.service.imports.ImportDemoDataService;
import com.axelor.apps.base.service.imports.importer.ExcelToCSV;
import com.axelor.apps.base.service.imports.importer.FactoryImporter;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.MetaScanner;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.db.repo.MetaModuleRepository;
import com.google.common.io.ByteStreams;
import com.google.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.text.ParseException;
import java.util.ArrayList;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ImportDemoDataServiceImpl
implements ImportDemoDataService {
    @Inject
    private MetaFiles metaFiles;
    @Inject
    FactoryImporter factoryImporter;
    @Inject
    private ExcelToCSV excelToCSV;
    @Inject
    private MetaModuleRepository metaModuleRepo;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean importDemoDataExcel(File excelFile, File logFile) throws FileNotFoundException, IOException, AxelorException, ParseException, ClassNotFoundException {
        XSSFWorkbook workBook = new XSSFWorkbook((InputStream)new FileInputStream(excelFile));
        try (FileOutputStream out = new FileOutputStream(logFile);){
            if (this.validateExcel(excelFile, out)) {
                out = new FileOutputStream(logFile);
                for (int i = 0; i < workBook.getNumberOfSheets(); ++i) {
                    Sheet sheet = workBook.getSheetAt(i);
                    String[] importDetails = this.getImportDetailsFromSheet(sheet);
                    File dataFile = File.createTempFile(importDetails[1], ".csv");
                    this.excelToCSV.writeTOCSV(dataFile, sheet, 3, 1);
                    File configFile = File.createTempFile(importDetails[2], ".xml");
                    configFile = this.getConfigFile(importDetails[0], configFile, importDetails[2]);
                    MetaFile logMetaFile = this.importFileData(dataFile, configFile, importDetails[1], importDetails[2]);
                    File file = MetaFiles.getPath((MetaFile)logMetaFile).toFile();
                    out.write(("Import: " + importDetails[1]).getBytes());
                    ByteStreams.copy((InputStream)new FileInputStream(file), (OutputStream)out);
                    out.write("\n\n".getBytes());
                }
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    private boolean validateExcel(File excelFile, FileOutputStream out) throws FileNotFoundException, IOException, AxelorException {
        XSSFWorkbook workBook = new XSSFWorkbook((InputStream)new FileInputStream(excelFile));
        boolean flag = true;
        for (int i = 0; i < workBook.getNumberOfSheets(); ++i) {
            Sheet sheet = workBook.getSheetAt(i);
            StringBuilder errorList = new StringBuilder();
            errorList.append("\nSheet : " + sheet.getSheetName());
            if (this.validateSheet(sheet, errorList)) continue;
            out.write(errorList.toString().getBytes());
            flag = false;
            out.write("\n".getBytes());
        }
        return flag;
    }

    private boolean validateSheet(Sheet sheet, StringBuilder errorList) throws IOException {
        boolean flag = true;
        if (this.validateModule(sheet.getRow(0), errorList)) {
            if (!this.validateConfigFile(sheet.getRow(0), sheet.getRow(2), errorList)) {
                flag = false;
            }
        } else {
            flag = false;
        }
        if (!this.validateDataFile(sheet.getRow(1), errorList)) {
            flag = false;
        }
        if (!this.validateHeader(sheet, errorList)) {
            flag = false;
        }
        return flag;
    }

    private boolean validateModule(Row moduleRow, StringBuilder errorList) throws IOException {
        if (this.validateRow(moduleRow, errorList, I18n.get((String)"Module")) && this.validateCell(moduleRow.getCell(0), errorList, I18n.get((String)"Module"))) {
            String moduleName = moduleRow.getCell(0).getStringCellValue();
            if (this.metaModuleRepo.findByName(moduleName) != null) {
                return true;
            }
            errorList.append(String.format("\n" + I18n.get((String)"%s module does not exist."), moduleName));
        }
        return false;
    }

    private boolean validateDataFile(Row dataFileRow, StringBuilder errorList) throws IOException {
        return this.validateRow(dataFileRow, errorList, I18n.get((String)"Data file")) && this.validateCell(dataFileRow.getCell(0), errorList, I18n.get((String)"Data file"));
    }

    private boolean validateConfigFile(Row moduleRow, Row configFileRow, StringBuilder errorList) throws IOException {
        if (this.validateRow(configFileRow, errorList, I18n.get((String)"Configuration file")) && this.validateCell(configFileRow.getCell(0), errorList, I18n.get((String)"Configuration file"))) {
            String configFileName;
            String moduleName = moduleRow.getCell(0).getStringCellValue();
            if (this.checkConfigFile(moduleName, configFileName = configFileRow.getCell(0).getStringCellValue())) {
                return true;
            }
            errorList.append(String.format(I18n.get((String)"\n%s configuration file is not exist."), configFileName));
        }
        return false;
    }

    private boolean validateHeader(Sheet sheet, StringBuilder errorList) throws IOException {
        boolean flag = true;
        Row headerRow = sheet.getRow(3);
        if (headerRow != null) {
            for (int cell = 1; cell < headerRow.getLastCellNum(); ++cell) {
                Cell headerCell = headerRow.getCell(cell);
                if (headerCell != null && headerCell.getCellType() == 1) continue;
                errorList.append("\n" + I18n.get((String)"Header is not valid."));
                flag = false;
            }
        } else {
            errorList.append("\n" + I18n.get((String)"Header is not valid."));
            flag = false;
        }
        return flag;
    }

    private boolean validateRow(Row row, StringBuilder errorList, String rowName) throws IOException {
        if (row == null) {
            errorList.append(String.format("\n" + I18n.get((String)"%s row must not be empty."), rowName));
            return false;
        }
        return true;
    }

    private boolean validateCell(Cell cell, StringBuilder errorList, String cellName) throws IOException {
        if (cell == null || cell.getCellType() != 1) {
            errorList.append(String.format("\n" + I18n.get((String)"%s cell is not valid."), cellName));
            return false;
        }
        return true;
    }

    private boolean checkConfigFile(String moduleName, String configFileName) {
        String dirNamePattern = "demo".replaceAll("/|\\\\", "(/|\\\\\\\\)");
        ArrayList files = new ArrayList();
        files.addAll(MetaScanner.findAll((String)moduleName, (String)dirNamePattern, (String)(configFileName + ".xml")));
        return !files.isEmpty();
    }

    private String[] getImportDetailsFromSheet(Sheet sheet) throws AxelorException {
        String[] importDetails = new String[3];
        Row moduleRow = sheet.getRow(0);
        Row dataFileRow = sheet.getRow(1);
        Row configFileRow = sheet.getRow(2);
        importDetails[0] = moduleRow.getCell(0).getStringCellValue();
        importDetails[1] = dataFileRow.getCell(0).getStringCellValue();
        importDetails[2] = configFileRow.getCell(0).getStringCellValue();
        return importDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File getConfigFile(String moduleName, File configFile, String configFileName) throws IOException, AxelorException {
        String dirNamePattern = "demo".replaceAll("/|\\\\", "(/|\\\\\\\\)");
        ArrayList files = new ArrayList();
        files.addAll(MetaScanner.findAll((String)moduleName, (String)dirNamePattern, (String)(configFileName + ".xml")));
        for (URL file : files) {
            try (FileOutputStream out = new FileOutputStream(configFile);){
                ByteStreams.copy((InputStream)file.openStream(), (OutputStream)out);
            }
        }
        return configFile;
    }

    private MetaFile importFileData(File dataFile, File configFile, String dataFileName, String configFileName) throws IOException, AxelorException {
        ImportConfiguration config = new ImportConfiguration();
        MetaFile configMetaFile = this.metaFiles.upload((InputStream)new FileInputStream(configFile), configFileName + ".xml");
        MetaFile dataMetaFile = this.metaFiles.upload((InputStream)new FileInputStream(dataFile), dataFileName + ".csv");
        config.setBindMetaFile(configMetaFile);
        config.setDataMetaFile(dataMetaFile);
        config.setTypeSelect("csv");
        ImportHistory importHistory = this.factoryImporter.createImporter(config).run();
        MetaFiles.getPath((MetaFile)configMetaFile).toFile().delete();
        MetaFiles.getPath((MetaFile)dataMetaFile).toFile().delete();
        return importHistory.getLogMetaFile();
    }
}

