/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.imports.listener;

import com.axelor.data.Listener;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImporterListener
implements Listener {
    protected Logger log = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private String name;
    private String importLog = "";
    private int totalRecord;
    private int successRecord;
    private int notNull;
    private int anomaly;

    public ImporterListener(String name) {
        this.name = name;
    }

    public String getImportLog() {
        String log = this.importLog;
        log = log + "\n" + I18n.get((String)"Total :") + " " + this.totalRecord + " " + I18n.get((String)"- Succeeded :") + " " + this.successRecord + " " + I18n.get((String)"- Not null :") + " " + this.notNull;
        log = log + "\n" + I18n.get((String)"Generated anomalies :") + this.anomaly;
        return log;
    }

    public void imported(Model bean) {
        if (bean != null) {
            ++this.notNull;
        }
    }

    public void imported(Integer total, Integer success) {
        this.totalRecord += total.intValue();
        this.successRecord += success.intValue();
    }

    public void handle(Model bean, Exception e) {
        ++this.anomaly;
        this.importLog = this.importLog + "\n" + e;
        TraceBackService.trace((Throwable)new AxelorException((Throwable)e, 5, I18n.get((String)"The line cannot be imported (import : %s)"), new Object[]{this.name}), (String)"import");
    }

    public boolean isImported() {
        return (this.anomaly == 0 || this.notNull == 0) && this.totalRecord == this.successRecord;
    }
}

