/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.message;

import com.axelor.app.internal.AppFilter;
import com.axelor.apps.base.db.BirtTemplate;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.PrintingSettings;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.base.service.message.TemplateMessageServiceBaseImpl;
import com.axelor.apps.base.service.user.UserService;
import com.axelor.apps.message.db.EmailAccount;
import com.axelor.apps.message.db.EmailAddress;
import com.axelor.apps.message.db.Message;
import com.axelor.apps.message.db.repo.MessageRepository;
import com.axelor.apps.message.service.MessageServiceImpl;
import com.axelor.apps.message.service.SendMailQueueService;
import com.axelor.auth.AuthUtils;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.inject.Beans;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.db.repo.MetaAttachmentRepository;
import com.axelor.tool.template.TemplateMaker;
import com.google.common.base.Joiner;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.mail.MessagingException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageServiceBaseImpl
extends MessageServiceImpl {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected UserService userService;
    protected AppBaseService appBaseService;

    @Inject
    public MessageServiceBaseImpl(MetaAttachmentRepository metaAttachmentRepository, MessageRepository messageRepository, SendMailQueueService sendMailQueueService, UserService userService, AppBaseService appBaseService) {
        super(metaAttachmentRepository, messageRepository, sendMailQueueService);
        this.userService = userService;
        this.appBaseService = appBaseService;
    }

    @Transactional
    public Message createMessage(String model, int id, String subject, String content, EmailAddress fromEmailAddress, List<EmailAddress> replyToEmailAddressList, List<EmailAddress> toEmailAddressList, List<EmailAddress> ccEmailAddressList, List<EmailAddress> bccEmailAddressList, Set<MetaFile> metaFiles, String addressBlock, int mediaTypeSelect, EmailAccount emailAccount, String signature) {
        Message message = super.createMessage(model, id, subject, content, fromEmailAddress, replyToEmailAddressList, toEmailAddressList, ccEmailAddressList, bccEmailAddressList, metaFiles, addressBlock, mediaTypeSelect, emailAccount, signature);
        message.setSenderUser(AuthUtils.getUser());
        message.setCompany(this.userService.getUserActiveCompany());
        return (Message)((Object)this.messageRepository.save((Model)((Object)message)));
    }

    public String printMessage(Message message) throws AxelorException {
        Company company = message.getCompany();
        if (company == null) {
            return null;
        }
        PrintingSettings printSettings = company.getPrintingSettings();
        if (printSettings == null || printSettings.getDefaultMailBirtTemplate() == null) {
            return null;
        }
        BirtTemplate birtTemplate = printSettings.getDefaultMailBirtTemplate();
        this.logger.debug("Default BirtTemplate : {}", (Object)birtTemplate);
        TemplateMaker maker = new TemplateMaker(company.getTimezone(), AppFilter.getLocale(), '$', '$');
        maker.setContext(this.messageRepository.find(message.getId()), Message.class.getSimpleName());
        String fileName = "Message " + message.getSubject() + "-" + this.appBaseService.getTodayDate(company).format(DateTimeFormatter.BASIC_ISO_DATE);
        return ((TemplateMessageServiceBaseImpl)((Object)Beans.get(TemplateMessageServiceBaseImpl.class))).generateBirtTemplateLink(maker, fileName, birtTemplate.getTemplateLink(), birtTemplate.getFormat(), birtTemplate.getBirtTemplateParameterList());
    }

    @Transactional(rollbackOn={Exception.class})
    public Message sendByEmail(Message message) throws MessagingException, AxelorException {
        if (((AppBaseService)Beans.get(AppBaseService.class)).getAppBase().getActivateSendingEmail().booleanValue()) {
            message.setStatusSelect(2);
            return super.sendByEmail(message);
        }
        return message;
    }

    public List<String> getEmailAddressNames(Set<EmailAddress> emailAddressSet) {
        ArrayList recipients = Lists.newArrayList();
        if (emailAddressSet != null) {
            for (EmailAddress emailAddress : emailAddressSet) {
                if (Strings.isNullOrEmpty((String)emailAddress.getName())) continue;
                recipients.add(emailAddress.getName());
            }
        }
        return recipients;
    }

    public String getToRecipients(Message message) {
        if (message.getToEmailAddressSet() != null && !message.getToEmailAddressSet().isEmpty()) {
            return Joiner.on((String)", \n").join(this.getEmailAddressNames(message.getToEmailAddressSet()));
        }
        return "";
    }

    public String getFullEmailAddress(EmailAddress emailAddress) {
        String partnerName = "";
        if (emailAddress.getPartner() != null) {
            partnerName = new String(emailAddress.getPartner().getName().getBytes(), StandardCharsets.ISO_8859_1);
        }
        return "\"" + partnerName + "\" <" + emailAddress.getAddress() + ">";
    }
}

