/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.message;

import com.axelor.app.internal.AppFilter;
import com.axelor.apps.ReportFactory;
import com.axelor.apps.base.db.BirtTemplate;
import com.axelor.apps.base.db.BirtTemplateParameter;
import com.axelor.apps.base.db.Language;
import com.axelor.apps.message.db.Template;
import com.axelor.apps.message.service.MessageService;
import com.axelor.apps.message.service.TemplateContextService;
import com.axelor.apps.message.service.TemplateMessageServiceImpl;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.auth.AuthUtils;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.axelor.tool.template.TemplateMaker;
import com.google.inject.Inject;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import org.eclipse.birt.core.data.DataTypeUtil;
import org.eclipse.birt.core.exception.BirtException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TemplateMessageServiceBaseImpl
extends TemplateMessageServiceImpl {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Inject
    public TemplateMessageServiceBaseImpl(MessageService messageService, TemplateContextService templateContextService) {
        super(AuthUtils.getUser() != null && AuthUtils.getUser().getActiveCompany() != null ? AuthUtils.getUser().getActiveCompany().getTimezone() : "", messageService, templateContextService);
    }

    public Set<MetaFile> getMetaFiles(Template template) throws AxelorException, IOException {
        Set metaFiles = super.getMetaFiles(template);
        if (template.getBirtTemplate() == null) {
            return metaFiles;
        }
        Locale locale = Optional.ofNullable(template.getLanguage()).map(Language::getCode).map(Locale::new).orElseGet(AppFilter::getLocale);
        this.maker.setLocale(locale);
        metaFiles.add(this.createMetaFileUsingBirtTemplate(this.maker, template.getBirtTemplate()));
        this.logger.debug("Metafile to attach: {}", (Object)metaFiles);
        return metaFiles;
    }

    public TemplateMaker initMaker(long objectId, String model, String tag, Template template) throws ClassNotFoundException {
        Locale locale = Optional.ofNullable(template.getLanguage()).map(Language::getCode).map(Locale::new).orElseGet(AppFilter::getLocale);
        this.maker.setLocale(locale);
        return super.initMaker(objectId, model, tag, template);
    }

    public MetaFile createMetaFileUsingBirtTemplate(TemplateMaker maker, BirtTemplate birtTemplate) throws AxelorException, IOException {
        this.logger.debug("Generate birt metafile: {}", (Object)birtTemplate.getName());
        String fileName = birtTemplate.getName() + "-" + LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
        File file = this.generateBirtTemplate(maker, fileName, birtTemplate.getTemplateLink(), birtTemplate.getFormat(), birtTemplate.getBirtTemplateParameterList());
        try (FileInputStream is = new FileInputStream(file);){
            MetaFile metaFile = ((MetaFiles)Beans.get(MetaFiles.class)).upload((InputStream)is, fileName + "." + birtTemplate.getFormat());
            return metaFile;
        }
    }

    public File generateBirtTemplate(TemplateMaker maker, String fileName, String modelPath, String format, List<BirtTemplateParameter> birtTemplateParameterList) throws AxelorException {
        File birtTemplate = null;
        ReportSettings reportSettings = this.generateTemplate(maker, fileName, modelPath, format, birtTemplateParameterList);
        if (reportSettings != null) {
            birtTemplate = reportSettings.getFile();
        }
        return birtTemplate;
    }

    public String generateBirtTemplateLink(TemplateMaker maker, String fileName, String modelPath, String format, List<BirtTemplateParameter> birtTemplateParameterList) throws AxelorException {
        String birtTemplateFileLink = null;
        ReportSettings reportSettings = this.generateTemplate(maker, fileName, modelPath, format, birtTemplateParameterList);
        if (reportSettings != null) {
            birtTemplateFileLink = reportSettings.getFileLink();
        }
        return birtTemplateFileLink;
    }

    private ReportSettings generateTemplate(TemplateMaker maker, String fileName, String modelPath, String format, List<BirtTemplateParameter> birtTemplateParameterList) throws AxelorException {
        if (modelPath == null || modelPath.isEmpty()) {
            return null;
        }
        ReportSettings reportSettings = ReportFactory.createReport(modelPath, fileName).addFormat(format);
        for (BirtTemplateParameter birtTemplateParameter : birtTemplateParameterList) {
            maker.setTemplate(birtTemplateParameter.getValue());
            try {
                reportSettings.addParam(birtTemplateParameter.getName(), this.convertValue(birtTemplateParameter.getType(), maker.make()));
            }
            catch (BirtException e) {
                throw new AxelorException(e.getCause(), 4, I18n.get((String)"Unable to generate Birt report file"));
            }
        }
        reportSettings.generate();
        return reportSettings;
    }

    private Object convertValue(String type, String value) throws BirtException {
        if ("boolean".equals(type)) {
            return DataTypeUtil.toBoolean((Object)value);
        }
        if ("dateTime".equals(type)) {
            return DataTypeUtil.toDate((Object)value);
        }
        if ("date".equals(type)) {
            return DataTypeUtil.toSqlDate((Object)value);
        }
        if ("time".equals(type)) {
            return DataTypeUtil.toSqlTime((Object)value);
        }
        if ("decimal".equals(type)) {
            return DataTypeUtil.toBigDecimal((Object)value);
        }
        if ("float".equals(type)) {
            return DataTypeUtil.toDouble((Object)value);
        }
        if ("string".equals(type)) {
            return DataTypeUtil.toLocaleNeutralString((Object)value);
        }
        if ("integer".equals(type)) {
            return DataTypeUtil.toInteger((Object)value);
        }
        return value;
    }
}

