/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.readers;

import com.axelor.apps.base.service.readers.DataReaderService;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.opencsv.CSVReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.invoke.MethodHandles;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CSVReaderService
implements DataReaderService {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private CSVReader csvReader = null;
    private List<String[]> totalRows = new ArrayList<String[]>();
    private String fileName;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean initialize(MetaFile input, String separator) {
        if (input == null) {
            return false;
        }
        this.fileName = input.getFileName().replaceAll(".csv", "");
        File inFile = MetaFiles.getPath((MetaFile)input).toFile();
        if (!inFile.exists()) {
            return false;
        }
        try (FileInputStream inSteam = new FileInputStream(inFile);){
            this.csvReader = new CSVReader((Reader)new InputStreamReader((InputStream)inSteam, StandardCharsets.UTF_8), separator.charAt(0));
            this.totalRows = this.csvReader.readAll();
            if (this.csvReader.getLinesRead() != 0L) return true;
            boolean bl = false;
            return bl;
        }
        catch (IOException e) {
            LOG.error(e.getMessage());
            return false;
        }
    }

    @Override
    public String[] read(String sheetName, int index, int headerSize) {
        if (this.csvReader == null || CollectionUtils.isEmpty(this.totalRows)) {
            return new String[0];
        }
        return this.totalRows.get(index);
    }

    @Override
    public int getTotalLines(String sheetName) {
        if (this.csvReader == null) {
            return 0;
        }
        return (int)this.csvReader.getLinesRead();
    }

    @Override
    public String[] getSheetNames() {
        if (this.csvReader == null || CollectionUtils.isEmpty(this.totalRows)) {
            return new String[0];
        }
        String[] sheets = new String[]{this.fileName};
        return sheets;
    }
}

