/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.readers;

import com.axelor.apps.base.service.readers.DataReaderService;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.Strings;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DataFormatter;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelReaderService
implements DataReaderService {
    private XSSFWorkbook book = null;
    private DataFormatter formatter = null;

    @Override
    public boolean initialize(MetaFile input, String separator) {
        if (input == null) {
            return false;
        }
        File inFile = MetaFiles.getPath((MetaFile)input).toFile();
        if (!inFile.exists()) {
            return false;
        }
        try {
            FileInputStream inSteam = new FileInputStream(inFile);
            this.book = new XSSFWorkbook((InputStream)inSteam);
            if (this.book.getNumberOfSheets() == 0) {
                return false;
            }
            this.formatter = new DataFormatter();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    @Override
    public String[] read(String sheetName, int index, int headerSize) {
        if (sheetName == null || this.book == null) {
            return null;
        }
        XSSFSheet sheet = this.book.getSheet(sheetName);
        if (sheet == null) {
            return null;
        }
        XSSFRow row = sheet.getRow(index);
        if (row == null) {
            return null;
        }
        if (headerSize == 0) {
            headerSize = row.getLastCellNum();
        }
        String[] vals = new String[headerSize];
        for (int i = 0; i < headerSize; ++i) {
            XSSFCell cell = row.getCell(i);
            if (cell == null) continue;
            vals[i] = this.formatter.formatCellValue((Cell)cell);
            if (!Strings.isNullOrEmpty((String)vals[i])) continue;
            vals[i] = null;
        }
        return vals;
    }

    @Override
    public String[] getSheetNames() {
        if (this.book == null) {
            return null;
        }
        String[] sheets = new String[this.book.getNumberOfSheets()];
        for (int count = 0; count < sheets.length; ++count) {
            sheets[count] = this.book.getSheetName(count);
        }
        return sheets;
    }

    @Override
    public int getTotalLines(String sheetName) {
        if (this.book == null || sheetName == null || this.book.getSheet(sheetName) == null) {
            return 0;
        }
        return this.book.getSheet(sheetName).getPhysicalNumberOfRows();
    }
}

