/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.tax;

import com.axelor.apps.account.db.AccountManagement;
import com.axelor.apps.account.db.FiscalPosition;
import com.axelor.apps.account.db.Tax;
import com.axelor.apps.account.db.TaxLine;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.ProductFamily;
import com.axelor.apps.base.service.tax.AccountManagementService;
import com.axelor.apps.base.service.tax.FiscalPositionService;
import com.axelor.apps.base.service.tax.TaxService;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.google.inject.Inject;
import java.lang.invoke.MethodHandles;
import java.time.LocalDate;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountManagementServiceImpl
implements AccountManagementService {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static final int CONFIG_OBJECT_PRODUCT = 1;
    protected static final int CONFIG_OBJECT_PRODUCT_FAMILY = 2;
    private FiscalPositionService fiscalPositionService;
    private TaxService taxService;

    @Inject
    public AccountManagementServiceImpl(FiscalPositionService fiscalPositionService, TaxService taxService) {
        this.fiscalPositionService = fiscalPositionService;
        this.taxService = taxService;
    }

    protected AccountManagement getAccountManagement(Product product, Company company, int configObject) {
        if (product == null) {
            return null;
        }
        switch (configObject) {
            case 1: {
                return this.getAccountManagement(product, company);
            }
            case 2: {
                return this.getAccountManagement(product.getProductFamily(), company);
            }
        }
        return null;
    }

    protected AccountManagement getAccountManagement(Product product, Company company) {
        return this.getAccountManagement(product.getAccountManagementList(), company);
    }

    protected AccountManagement getAccountManagement(ProductFamily productFamily, Company company) {
        if (productFamily == null) {
            return null;
        }
        return this.getAccountManagement(productFamily.getAccountManagementList(), company);
    }

    @Override
    public AccountManagement getAccountManagement(List<AccountManagement> accountManagements, Company company) {
        if (accountManagements == null || accountManagements.isEmpty()) {
            return null;
        }
        for (AccountManagement accountManagement : accountManagements) {
            if (!accountManagement.getCompany().equals((Object)company)) continue;
            LOG.debug("Obtention de la configuration comptable => soci\u00e9t\u00e9: {}", (Object)company.getName());
            return accountManagement;
        }
        return null;
    }

    @Override
    public Tax getProductTax(Product product, Company company, FiscalPosition fiscalPosition, boolean isPurchase) throws AxelorException {
        LOG.debug("Get the tax for the product {} (company : {}, purchase : {}, fiscal position : {})", new Object[]{product.getCode(), company.getName(), isPurchase, fiscalPosition != null ? fiscalPosition.getCode() : null});
        Tax generalTax = this.getProductTax(product, company, isPurchase, 1);
        Tax tax = this.fiscalPositionService.getTax(fiscalPosition, generalTax);
        if (tax != null) {
            return tax;
        }
        throw new AxelorException(4, I18n.get((String)"Tax configuration is missing for Product: %s (company: %s)"), new Object[]{product.getCode(), company.getName()});
    }

    protected Tax getProductTax(Product product, Company company, boolean isPurchase, int configObject) {
        AccountManagement accountManagement = this.getAccountManagement(product, company, configObject);
        Tax tax = null;
        if (accountManagement != null) {
            tax = isPurchase ? accountManagement.getPurchaseTax() : accountManagement.getSaleTax();
        }
        if (tax == null && configObject == 1) {
            return this.getProductTax(product, company, isPurchase, 2);
        }
        return tax;
    }

    @Override
    public TaxLine getTaxLine(LocalDate date, Product product, Company company, FiscalPosition fiscalPosition, boolean isPurchase) throws AxelorException {
        TaxLine taxLine = this.taxService.getTaxLine(this.getProductTax(product, company, fiscalPosition, isPurchase), date);
        if (taxLine != null) {
            return taxLine;
        }
        throw new AxelorException(4, I18n.get((String)"No tax found for product %s"), new Object[]{product.getCode()});
    }
}

