/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.user;

import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.auth.db.User;
import com.axelor.exception.AxelorException;
import com.axelor.meta.CallMethod;
import com.axelor.meta.db.MetaFile;
import com.axelor.team.db.Team;
import com.google.inject.persist.Transactional;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.mail.MessagingException;

public interface UserService {
    public User getUser();

    public Long getUserId();

    @CallMethod
    public Company getUserActiveCompany();

    public Long getUserActiveCompanyId();

    public MetaFile getUserActiveCompanyLogo();

    public String getUserActiveCompanyLogoLink();

    @CallMethod
    public Team getUserActiveTeam();

    @CallMethod
    public Long getUserActiveTeamId();

    @CallMethod
    public Partner getUserPartner();

    @Transactional
    public void createPartner(User var1);

    public String getLanguage();

    public Optional<Address> getUserActiveCompanyAddress();

    public User changeUserPassword(User var1, Map<String, Object> var2) throws ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException, AxelorException;

    public void processChangedPassword(User var1) throws ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException, AxelorException;

    public boolean matchPasswordPattern(CharSequence var1);

    public CharSequence generateRandomPassword();

    @CallMethod
    public String getPasswordPatternDescription();

    public boolean verifyCurrentUserPassword(String var1);

    @Transactional
    public void generateRandomPasswordForUsers(List<Long> var1);
}

