/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.user;

import com.axelor.app.AppSettings;
import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.AppBase;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.base.service.user.UserService;
import com.axelor.apps.message.db.Template;
import com.axelor.apps.message.service.TemplateMessageService;
import com.axelor.auth.AuthService;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.auth.db.repo.UserRepository;
import com.axelor.common.StringUtils;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.axelor.team.db.Team;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.IOException;
import java.lang.invoke.MethodHandles;
import java.security.SecureRandom;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import javax.validation.ValidationException;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.commons.math3.exception.TooManyIterationsException;
import org.apache.shiro.session.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserServiceImpl
implements UserService {
    @Inject
    private UserRepository userRepo;
    @Inject
    private MetaFiles metaFiles;
    public static final String DEFAULT_LOCALE = "en";
    private static final String PATTERN_ACCES_RESTRICTION = "(((?=.*[a-z])(?=.*[A-Z])(?=.*\\d))|((?=.*[a-z])(?=.*[A-Z])(?=.*\\W))|((?=.*[a-z])(?=.*\\d)(?=.*\\W))|((?=.*[A-Z])(?=.*\\d)(?=.*\\W))).{8,}";
    private static final Pattern PATTERN = Pattern.compile((String)MoreObjects.firstNonNull((Object)AppSettings.get().get("user.password.pattern"), (Object)"(((?=.*[a-z])(?=.*[A-Z])(?=.*\\d))|((?=.*[a-z])(?=.*[A-Z])(?=.*\\W))|((?=.*[a-z])(?=.*\\d)(?=.*\\W))|((?=.*[A-Z])(?=.*\\d)(?=.*\\W))).{8,}"));
    private static final String PATTERN_DESCRIPTION = PATTERN.pattern().equals("(((?=.*[a-z])(?=.*[A-Z])(?=.*\\d))|((?=.*[a-z])(?=.*[A-Z])(?=.*\\W))|((?=.*[a-z])(?=.*\\d)(?=.*\\W))|((?=.*[A-Z])(?=.*\\d)(?=.*\\W))).{8,}") ? "Password must have at least 8 characters with at least three of these four types: lowercase, uppercase, digit, special." : "Password doesn't match with configured pattern.";
    private static final String GEN_CHARS = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ!\"#$%&'()*+,-./:;<=>?@[\\]^_`{|}~";
    private static final Pair<Integer, Integer> GEN_BOUNDS = Pair.of((Object)12, (Object)22);
    private static final int GEN_LOOP_LIMIT = 1000;
    private static final SecureRandom random = new SecureRandom();
    private static final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    @Override
    public User getUser() {
        User user = null;
        try {
            user = AuthUtils.getUser();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (user == null) {
            user = this.userRepo.findByCode("admin");
        }
        return user;
    }

    @Override
    public Long getUserId() {
        User user = this.getUser();
        if (user == null) {
            return null;
        }
        return user.getId();
    }

    @Override
    public Company getUserActiveCompany() {
        User user = this.getUser();
        if (user == null) {
            return null;
        }
        return user.getActiveCompany();
    }

    @Override
    public Long getUserActiveCompanyId() {
        Company company = this.getUserActiveCompany();
        if (company == null) {
            return null;
        }
        return company.getId();
    }

    @Override
    public MetaFile getUserActiveCompanyLogo() {
        Company company = this.getUserActiveCompany();
        if (company == null) {
            return null;
        }
        return company.getLogo();
    }

    @Override
    public String getUserActiveCompanyLogoLink() {
        Company company = this.getUserActiveCompany();
        if (company == null) {
            return null;
        }
        MetaFile logo = company.getLogo();
        if (logo == null) {
            return null;
        }
        return this.metaFiles.getDownloadLink(logo, (Model)((Object)company));
    }

    @Override
    public Optional<Address> getUserActiveCompanyAddress() {
        Company company = this.getUserActiveCompany();
        if (company != null) {
            return Optional.ofNullable(company.getAddress());
        }
        return Optional.empty();
    }

    @Override
    public Team getUserActiveTeam() {
        User user = this.getUser();
        if (user == null) {
            return null;
        }
        return user.getActiveTeam();
    }

    @Override
    public Long getUserActiveTeamId() {
        Team team = this.getUserActiveTeam();
        if (team == null) {
            return null;
        }
        return team.getId();
    }

    @Override
    public Partner getUserPartner() {
        User user = this.getUser();
        if (user == null) {
            return null;
        }
        return user.getPartner();
    }

    @Override
    @Transactional
    public void createPartner(User user) {
        Partner partner = new Partner();
        partner.setPartnerTypeSelect(2);
        partner.setIsContact(true);
        partner.setName(user.getName());
        partner.setFullName(user.getName());
        partner.setTeam(user.getActiveTeam());
        partner.setUser(user);
        ((PartnerRepository)((Object)Beans.get(PartnerRepository.class))).save((Model)((Object)partner));
        user.setPartner(partner);
        this.userRepo.save((Model)((Object)user));
    }

    @Override
    public String getLanguage() {
        User user = this.getUser();
        if (user != null && !Strings.isNullOrEmpty((String)user.getLanguage())) {
            return user.getLanguage();
        }
        return DEFAULT_LOCALE;
    }

    @Override
    public boolean matchPasswordPattern(CharSequence password) {
        return PATTERN.matcher(password).matches();
    }

    @Override
    public User changeUserPassword(User user, Map<String, Object> values) throws ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException, AxelorException {
        Preconditions.checkNotNull((Object)((Object)user), (Object)I18n.get((String)"User cannot be null."));
        Preconditions.checkNotNull(values, (Object)I18n.get((String)"User context cannot be null."));
        String oldPassword = (String)values.get("oldPassword");
        String newPassword = (String)values.get("newPassword");
        String chkPassword = (String)values.get("chkPassword");
        if (StringUtils.isBlank((CharSequence)newPassword)) {
            return user;
        }
        if (StringUtils.isBlank((CharSequence)oldPassword)) {
            throw new ValidationException(I18n.get((String)"Current user password is not provided."));
        }
        if (!newPassword.equals(chkPassword)) {
            throw new ValidationException(I18n.get((String)"Confirm password doesn't match with new password."));
        }
        if (!this.matchPasswordPattern(newPassword)) {
            throw new ValidationException(I18n.get((String)PATTERN_DESCRIPTION));
        }
        User current = AuthUtils.getUser();
        AuthService authService = AuthService.getInstance();
        if (!authService.match(oldPassword, current.getPassword())) {
            throw new ValidationException(I18n.get((String)"Current user password is wrong."));
        }
        user.setTransientPassword(newPassword);
        return user;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Transactional(rollbackOn={Exception.class})
    public void processChangedPassword(User user) throws ClassNotFoundException, InstantiationException, IllegalAccessException, MessagingException, IOException, AxelorException {
        Preconditions.checkNotNull((Object)((Object)user), (Object)I18n.get((String)"User cannot be null."));
        try {
            if (!user.getSendEmailUponPasswordChange().booleanValue()) {
                return;
            }
            if (user.equals((Object)AuthUtils.getUser())) {
                logger.debug("User {} changed own password.", (Object)user.getCode());
                return;
            }
            AppBase appBase = ((AppBaseService)Beans.get(AppBaseService.class)).getAppBase();
            Template template = appBase.getPasswordChangedTemplate();
            if (template == null) {
                throw new AxelorException((Model)((Object)appBase), 3, I18n.get((String)"Template for changed password is missing."));
            }
            TemplateMessageService templateMessageService = (TemplateMessageService)Beans.get(TemplateMessageService.class);
            templateMessageService.generateAndSendMessage((Model)((Object)user), template);
        }
        finally {
            user.setTransientPassword(null);
        }
    }

    @Override
    public CharSequence generateRandomPassword() {
        for (int genLoopIndex = 0; genLoopIndex < 1000; ++genLoopIndex) {
            int len = random.ints((Integer)GEN_BOUNDS.getLeft(), (Integer)GEN_BOUNDS.getRight()).findFirst().getAsInt();
            StringBuilder sb = new StringBuilder(len);
            for (int i = 0; i < len; ++i) {
                sb.append(GEN_CHARS.charAt(random.nextInt(GEN_CHARS.length())));
            }
            String result = sb.toString();
            if (!this.matchPasswordPattern(result)) continue;
            return result;
        }
        throw new TooManyIterationsException((Number)1000);
    }

    @Override
    public String getPasswordPatternDescription() {
        return I18n.get((String)PATTERN_DESCRIPTION);
    }

    @Override
    public boolean verifyCurrentUserPassword(String password) {
        if (!StringUtils.isBlank((CharSequence)password)) {
            User current = AuthUtils.getUser();
            AuthService authService = AuthService.getInstance();
            if (authService.match(password, current.getPassword())) {
                return true;
            }
        }
        return false;
    }

    @Override
    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public void generateRandomPasswordForUsers(List<Long> userIds) {
        AuthService authService = (AuthService)Beans.get(AuthService.class);
        LocalDateTime todayDateTime = ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDateTime().toLocalDateTime();
        for (Long userId : userIds) {
            User user = (User)((Object)this.userRepo.find(userId));
            String password = this.generateRandomPassword().toString();
            user.setTransientPassword(password);
            password = authService.encrypt(password);
            user.setPassword(password);
            user.setPasswordUpdatedOn(todayDateTime);
            this.userRepo.save((Model)((Object)user));
        }
        if (userIds.contains(this.getUserId())) {
            Session session = AuthUtils.getSubject().getSession();
            session.setAttribute((Object)"loginDate", (Object)todayDateTime);
        }
    }
}

