/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.service.weeklyplanning;

import com.axelor.apps.base.db.DayPlanning;
import com.axelor.apps.base.db.WeeklyPlanning;
import com.axelor.apps.base.service.user.UserService;
import com.axelor.apps.base.service.weeklyplanning.WeeklyPlanningService;
import com.axelor.common.ObjectUtils;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.google.inject.persist.Transactional;
import java.math.BigDecimal;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.ChronoUnit;
import java.util.Comparator;
import java.util.List;
import java.util.Optional;

public class WeeklyPlanningServiceImp
implements WeeklyPlanningService {
    @Override
    public DayOfWeek getFirstDayOfWeek() {
        Optional<DayPlanning> min;
        WeeklyPlanning planning = ((UserService)Beans.get(UserService.class)).getUserActiveCompany().getWeeklyPlanning();
        if (planning != null && ObjectUtils.notEmpty(planning.getWeekDays()) && (min = planning.getWeekDays().stream().min(Comparator.comparing(DayPlanning::getSequence))).isPresent()) {
            return this.getDayOfWeek(min.get());
        }
        return DayOfWeek.MONDAY;
    }

    private DayOfWeek getDayOfWeek(DayPlanning day) {
        switch (day.getName()) {
            case "monday": {
                return DayOfWeek.MONDAY;
            }
            case "tuesday": {
                return DayOfWeek.TUESDAY;
            }
            case "wednesday": {
                return DayOfWeek.WEDNESDAY;
            }
            case "thursday": {
                return DayOfWeek.THURSDAY;
            }
            case "friday": {
                return DayOfWeek.FRIDAY;
            }
            case "saturday": {
                return DayOfWeek.SATURDAY;
            }
            case "sunday": {
                return DayOfWeek.SUNDAY;
            }
        }
        return DayOfWeek.SUNDAY;
    }

    @Override
    @Transactional
    public WeeklyPlanning initPlanning(WeeklyPlanning planning) {
        String[] dayTab = new String[]{"monday", "tuesday", "wednesday", "thursday", "friday", "saturday", "sunday"};
        for (int i = 0; i < dayTab.length; ++i) {
            DayPlanning day = new DayPlanning();
            day.setName(dayTab[i]);
            planning.addWeekDay(day);
        }
        return planning;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public WeeklyPlanning checkPlanning(WeeklyPlanning planning) throws AxelorException {
        List<DayPlanning> listDay = planning.getWeekDays();
        for (DayPlanning dayPlanning : listDay) {
            if (dayPlanning.getMorningFrom() != null && dayPlanning.getMorningTo() != null && dayPlanning.getMorningFrom().isAfter(dayPlanning.getMorningTo())) {
                String message = this.messageInCheckPlanning("Invalid times %s morning", dayPlanning);
                throw new AxelorException(5, message);
            }
            if (dayPlanning.getMorningTo() != null && dayPlanning.getAfternoonFrom() != null && dayPlanning.getMorningTo().isAfter(dayPlanning.getAfternoonFrom())) {
                String message = this.messageInCheckPlanning("Invalid times on %s between morning and afternoon", dayPlanning);
                throw new AxelorException(5, message);
            }
            if (dayPlanning.getAfternoonFrom() != null && dayPlanning.getAfternoonTo() != null && dayPlanning.getAfternoonFrom().isAfter(dayPlanning.getAfternoonTo())) {
                String message = this.messageInCheckPlanning("Invalid times %s afternoon", dayPlanning);
                throw new AxelorException(5, message);
            }
            if (!(dayPlanning.getMorningFrom() == null && dayPlanning.getMorningTo() != null || dayPlanning.getMorningTo() == null && dayPlanning.getMorningFrom() != null || dayPlanning.getAfternoonFrom() == null && dayPlanning.getAfternoonTo() != null) && (dayPlanning.getAfternoonTo() != null || dayPlanning.getAfternoonFrom() == null)) continue;
            String message = this.messageInCheckPlanning("Some times are null and should not on %s", dayPlanning);
            throw new AxelorException(5, message);
        }
        return planning;
    }

    @Override
    public double getWorkingDayValueInDays(WeeklyPlanning planning, LocalDate date) {
        double value = 0.0;
        DayPlanning dayPlanning = this.findDayPlanning(planning, date);
        if (dayPlanning == null) {
            return value;
        }
        if (dayPlanning.getMorningFrom() != null && dayPlanning.getMorningTo() != null) {
            value += 0.5;
        }
        if (dayPlanning.getAfternoonFrom() != null && dayPlanning.getAfternoonTo() != null) {
            value += 0.5;
        }
        return value;
    }

    @Override
    public double getWorkingDayValueInDaysWithSelect(WeeklyPlanning planning, LocalDate date, boolean morning, boolean afternoon) {
        double value = 0.0;
        DayPlanning dayPlanning = this.findDayPlanning(planning, date);
        if (dayPlanning == null) {
            return value;
        }
        if (morning && dayPlanning.getMorningFrom() != null && dayPlanning.getMorningTo() != null) {
            value += 0.5;
        }
        if (afternoon && dayPlanning.getAfternoonFrom() != null && dayPlanning.getAfternoonTo() != null) {
            value += 0.5;
        }
        return value;
    }

    @Override
    public BigDecimal getWorkingDayValueInHours(WeeklyPlanning weeklyPlanning, LocalDate date, LocalTime from, LocalTime to) {
        double value = 0.0;
        DayPlanning dayPlanning = this.findDayPlanning(weeklyPlanning, date);
        if (dayPlanning == null) {
            return BigDecimal.valueOf(value);
        }
        LocalTime morningFrom = dayPlanning.getMorningFrom();
        LocalTime morningTo = dayPlanning.getMorningTo();
        if (morningFrom != null && morningTo != null) {
            LocalTime morningEnd;
            LocalTime morningBegin = from != null && from.isAfter(morningFrom) ? from : morningFrom;
            LocalTime localTime = morningEnd = to != null && to.isBefore(morningTo) ? to : morningTo;
            if (to != null && to.isBefore(morningBegin)) {
                return BigDecimal.ZERO;
            }
            if (from == null || from.isBefore(morningEnd)) {
                value += (double)ChronoUnit.MINUTES.between(morningBegin, morningEnd);
            }
        }
        LocalTime afternoonFrom = dayPlanning.getAfternoonFrom();
        LocalTime afternoonTo = dayPlanning.getAfternoonTo();
        if (afternoonFrom != null && afternoonTo != null) {
            LocalTime afternoonEnd;
            LocalTime afternoonBegin = from != null && from.isAfter(afternoonFrom) ? from : afternoonFrom;
            LocalTime localTime = afternoonEnd = to != null && to.isBefore(afternoonTo) ? to : afternoonTo;
            if (from != null && from.isAfter(afternoonEnd)) {
                return BigDecimal.ZERO;
            }
            if (to == null || to.isAfter(afternoonBegin)) {
                value += (double)ChronoUnit.MINUTES.between(afternoonBegin, afternoonEnd);
            }
        }
        return BigDecimal.valueOf(value).divide(BigDecimal.valueOf(60L), 4);
    }

    @Override
    public DayPlanning findDayPlanning(WeeklyPlanning planning, LocalDate date) {
        int dayOfWeek = date.getDayOfWeek().getValue();
        switch (dayOfWeek) {
            case 1: {
                return this.findDayWithName(planning, "monday");
            }
            case 2: {
                return this.findDayWithName(planning, "tuesday");
            }
            case 3: {
                return this.findDayWithName(planning, "wednesday");
            }
            case 4: {
                return this.findDayWithName(planning, "thursday");
            }
            case 5: {
                return this.findDayWithName(planning, "friday");
            }
            case 6: {
                return this.findDayWithName(planning, "saturday");
            }
            case 7: {
                return this.findDayWithName(planning, "sunday");
            }
        }
        return this.findDayWithName(planning, "null");
    }

    @Override
    public DayPlanning findDayWithName(WeeklyPlanning planning, String name) {
        List<DayPlanning> dayPlanningList = planning.getWeekDays();
        for (DayPlanning dayPlanning : dayPlanningList) {
            if (!dayPlanning.getName().equals(name)) continue;
            return dayPlanning;
        }
        return null;
    }

    public String messageInCheckPlanning(String message, DayPlanning dayPlanning) {
        String dayPlanningName = dayPlanning.getName();
        return String.format(I18n.get((String)message), I18n.get((String)(Character.toUpperCase(dayPlanningName.charAt(0)) + dayPlanningName.substring(1))).toLowerCase());
    }
}

