/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.syncContact;

import com.axelor.apps.base.db.Address;
import com.axelor.apps.base.db.City;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Country;
import com.axelor.apps.base.db.Function;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.PartnerAddress;
import com.axelor.apps.base.db.Sequence;
import com.axelor.apps.base.db.SyncContact;
import com.axelor.apps.base.db.SyncContactHistoric;
import com.axelor.apps.base.db.repo.AddressRepository;
import com.axelor.apps.base.db.repo.CityRepository;
import com.axelor.apps.base.db.repo.CompanyRepository;
import com.axelor.apps.base.db.repo.CountryRepository;
import com.axelor.apps.base.db.repo.FunctionRepository;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.db.repo.SequenceRepository;
import com.axelor.apps.base.db.repo.SyncContactRepository;
import com.axelor.apps.base.service.AddressService;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.base.service.user.UserService;
import com.axelor.apps.base.syncContact.PeopleRequest;
import com.axelor.apps.base.syncContact.SyncContactResponse;
import com.axelor.apps.message.db.repo.EmailAddressRepository;
import com.axelor.apps.tool.EmailTool;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.db.mapper.Mapper;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.rpc.Response;
import com.google.api.services.people.v1.model.EmailAddress;
import com.google.api.services.people.v1.model.Name;
import com.google.api.services.people.v1.model.Organization;
import com.google.api.services.people.v1.model.Person;
import com.google.api.services.people.v1.model.PhoneNumber;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;

@Consumes(value={"application/json"})
@Produces(value={"application/json"})
@Path(value="/synccontact")
public class SyncContactService {
    private PartnerRepository partnerRepo;
    private CompanyRepository companyRepo;
    private CityRepository cityRepo;
    private CountryRepository countryRepo;
    private AddressRepository addressRepo;
    private SyncContactRepository syncContactRepo;
    private EmailAddressRepository emailAddressRepo;
    private UserService userService;
    private FunctionRepository functionRepo;
    private String importOrigin = "Import Google Contact " + ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDate(Optional.ofNullable(AuthUtils.getUser()).map(User::getActiveCompany).orElse(null));
    private static final String SYNC_CONTACT_OLD_EMAIL = "Old email";
    private static final String SYNC_CONTACT_GOOGLE_EMAIL = "Google email";
    private static final String SYNC_CONTACT_OLD_ADDR = "Old address";
    private static final String SYNC_CONTACT_GOOGLE_ADDR = "Google address";
    private static final String SYNC_CONTACT_OLD_PHONE_NUMB = "Old phone number";
    private static final String SYNC_CONTACT_GOOGLE_PHONE_NUMB = "Google phone number";
    private static final String SYNC_CONTACT_COMPANY = "Company";
    private static final String SYNC_CONTACT_OLD_JOBTITLE = "Old job title";
    private static final String SYNC_CONTACT_NEW_JOBTITLE = "New job title";
    private static final String SYNC_CONTACT_AUTH_FAILED = "Authentication failed.";
    private static final String SYNC_CONTACT_NO_IMPORT = "No contact to import.";
    private static final String SYNC_CONTACT_IMPORT_SUCCESSFUL = "Import successful.";

    @Inject
    public SyncContactService(PartnerRepository partnerRepo, CompanyRepository companyRepo, CityRepository cityRepo, CountryRepository countryRepo, AddressRepository addressRepo, SyncContactRepository syncContactRepo, EmailAddressRepository emailAddressRepo, UserService userService, FunctionRepository functionRepo) {
        this.partnerRepo = partnerRepo;
        this.companyRepo = companyRepo;
        this.cityRepo = cityRepo;
        this.countryRepo = countryRepo;
        this.addressRepo = addressRepo;
        this.syncContactRepo = syncContactRepo;
        this.emailAddressRepo = emailAddressRepo;
        this.userService = userService;
        this.functionRepo = functionRepo;
    }

    @POST
    @Path(value="/key/{id}")
    public SyncContactResponse getKeyAndClientId(@PathParam(value="id") Long id) {
        SyncContact syncContact = (SyncContact)((Object)this.syncContactRepo.find(id));
        if (syncContact == null) {
            return null;
        }
        SyncContactResponse response = new SyncContactResponse();
        response.setClientid(syncContact.getCid());
        response.setKey(syncContact.getGoogleApiKey());
        response.setAuthFailed(I18n.get((String)SYNC_CONTACT_AUTH_FAILED));
        response.setImportSuccessful(I18n.get((String)SYNC_CONTACT_IMPORT_SUCCESSFUL));
        response.setNoImport(I18n.get((String)SYNC_CONTACT_NO_IMPORT));
        return response;
    }

    @POST
    @Path(value="/sync/{id}")
    public Response importContact(@PathParam(value="id") Long id, PeopleRequest request) {
        if (request == null || request.getPeople() == null || id == null) {
            return new Response();
        }
        this.importAllContact(id, request.getPeople());
        return new Response();
    }

    public void importAllContact(Long id, List<Person> people) {
        int i = 0;
        SyncContact syncContact = (SyncContact)((Object)this.syncContactRepo.find(id));
        if (syncContact == null) {
            return;
        }
        SyncContactHistoric syncContactHistoric = new SyncContactHistoric();
        for (Person googlePerson : people) {
            Partner partner = this.importContact(googlePerson, syncContact.getUpdateContactField());
            if (partner != null) {
                syncContactHistoric.addPartnerSetItem(partner);
            }
            if (i % 10 == 0) {
                JPA.clear();
            }
            ++i;
        }
        this.updateSyncContact(id, syncContactHistoric);
    }

    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public void updateSyncContact(Long id, SyncContactHistoric syncContactHistoric) {
        SyncContact syncContact = (SyncContact)((Object)this.syncContactRepo.find(id));
        syncContactHistoric.setUser(this.userService.getUser());
        HashSet<Partner> partnerSet = new HashSet<Partner>();
        for (Partner partner : syncContactHistoric.getPartnerSet()) {
            Partner find = (Partner)((Object)this.partnerRepo.find(partner.getId()));
            if (find == null) continue;
            partnerSet.add(find);
        }
        syncContactHistoric.clearPartnerSet();
        syncContactHistoric.setPartnerSet(partnerSet);
        syncContact.addSyncContactHistoricListItem(syncContactHistoric);
        this.syncContactRepo.save((Model)((Object)syncContact));
    }

    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public Partner importContact(Person googlePerson, Boolean updateContactField) {
        Partner partner;
        if (googlePerson.getNames() == null) {
            return null;
        }
        Name nameGoogle = (Name)Mapper.toBean(Name.class, (Map)((Map)googlePerson.getNames().get(0)));
        if (Strings.isNullOrEmpty((String)nameGoogle.getFamilyName())) {
            return null;
        }
        nameGoogle.setFamilyName(nameGoogle.getFamilyName().trim());
        String query = "self.name = '" + nameGoogle.getFamilyName() + "' ";
        if (!Strings.isNullOrEmpty((String)nameGoogle.getGivenName())) {
            nameGoogle.setGivenName(nameGoogle.getGivenName().trim());
            query = query + " AND self.firstName = '" + nameGoogle.getGivenName() + "' ";
        }
        partner = (partner = (Partner)((Object)this.partnerRepo.all().filter(query).fetchOne())) == null ? this.createPartner(googlePerson, nameGoogle) : this.updatePartner(googlePerson, partner, updateContactField);
        this.importCompany(googlePerson, partner, updateContactField);
        return partner;
    }

    public Partner createPartner(Person googlePerson, Name googleName) {
        Partner partner = new Partner();
        this.setDefaultPartnerValue(partner);
        this.importName(googleName, partner);
        this.importEmailAddress(googlePerson, partner, true);
        this.importAddress(googlePerson, partner, true);
        this.importPhoneNumber(googlePerson, partner, true);
        return (Partner)((Object)this.partnerRepo.save((Model)((Object)partner)));
    }

    protected void setDefaultPartnerValue(Partner partner) {
        partner.setPartnerTypeSelect(2);
        Sequence partnerSeq = ((SequenceRepository)((Object)Beans.get(SequenceRepository.class))).findByCode("partner");
        String seq = ((SequenceService)Beans.get(SequenceService.class)).getSequenceNumber(partnerSeq);
        partner.setUser(this.userService.getUser());
        partner.setPartnerSeq(seq);
        partner.setIsContact(true);
        partner.setImportOrigin(this.importOrigin);
    }

    protected void importName(Name googleName, Partner partner) {
        String fullName = googleName.getFamilyName() + " " + googleName.getGivenName();
        partner.setName(googleName.getFamilyName());
        partner.setFirstName(googleName.getGivenName());
        partner.setFullName(fullName);
        partner.setSimpleFullName(fullName);
    }

    protected void importEmailAddress(Person googlePerson, Partner partner, Boolean updateContactField) {
        if (googlePerson.getEmailAddresses() == null) {
            return;
        }
        EmailAddress googleEmail = (EmailAddress)Mapper.toBean(EmailAddress.class, (Map)((Map)googlePerson.getEmailAddresses().get(0)));
        if (Strings.isNullOrEmpty((String)googleEmail.getValue()) || !EmailTool.isValidEmailAddress((String)googleEmail.getValue())) {
            return;
        }
        if (partner.getEmailAddress() == null || Strings.isNullOrEmpty((String)partner.getEmailAddress().getAddress())) {
            com.axelor.apps.message.db.EmailAddress partnerEmail = this.createEmailAddress(googleEmail.getValue());
            partnerEmail.setPartner(partner);
            partner.setEmailAddress(partnerEmail);
        } else if (!partner.getEmailAddress().getAddress().equalsIgnoreCase(googleEmail.getValue())) {
            if (updateContactField.booleanValue()) {
                com.axelor.apps.message.db.EmailAddress partnerEmail = this.createEmailAddress(googleEmail.getValue());
                this.updateDescription(partner, I18n.get((String)SYNC_CONTACT_OLD_EMAIL), partner.getEmailAddress().getAddress());
                partnerEmail.setPartner(partner);
                partner.setEmailAddress(partnerEmail);
            } else {
                this.updateDescription(partner, I18n.get((String)SYNC_CONTACT_GOOGLE_EMAIL), googleEmail.getValue());
            }
        }
    }

    protected com.axelor.apps.message.db.EmailAddress createEmailAddress(String googleEmail) {
        com.axelor.apps.message.db.EmailAddress email = new com.axelor.apps.message.db.EmailAddress();
        email.setAddress(googleEmail);
        email.setName(googleEmail);
        email.setImportOrigin(this.importOrigin);
        return (com.axelor.apps.message.db.EmailAddress)((Object)this.emailAddressRepo.save((Model)((Object)email)));
    }

    protected void importAddress(Person googlePerson, Partner partner, Boolean updateContactField) {
        Address partnerAddr;
        if (googlePerson.getAddresses() == null) {
            return;
        }
        com.google.api.services.people.v1.model.Address googleAddr = (com.google.api.services.people.v1.model.Address)Mapper.toBean(com.google.api.services.people.v1.model.Address.class, (Map)((Map)googlePerson.getAddresses().get(0)));
        if (Strings.isNullOrEmpty((String)googleAddr.getCountryCode()) || Strings.isNullOrEmpty((String)googleAddr.getCountry()) || Strings.isNullOrEmpty((String)googleAddr.getStreetAddress()) || Strings.isNullOrEmpty((String)googleAddr.getPostalCode())) {
            return;
        }
        String query = "self.zip = '" + googleAddr.getPostalCode() + "' AND self.addressL7Country.alpha2Code = '" + googleAddr.getCountryCode() + "' AND self.addressL4 = '" + googleAddr.getStreetAddress() + "'";
        if (!Strings.isNullOrEmpty((String)googleAddr.getCity())) {
            query = query + " AND self.city.name = '" + googleAddr.getCity() + "'";
        }
        if ((partnerAddr = (Address)((Object)this.addressRepo.all().filter(query).fetchOne())) == null) {
            partnerAddr = this.createAddress(googleAddr);
        }
        if (partner.getMainAddress() == null) {
            partner.setMainAddress(partnerAddr);
            this.createPartnerAddress(partner, partnerAddr);
        } else if (!partner.getMainAddress().equals((Object)partnerAddr)) {
            if (updateContactField.booleanValue()) {
                this.updateDescription(partner, I18n.get((String)SYNC_CONTACT_OLD_ADDR), partner.getMainAddress().getFullName());
                partner.setMainAddress(partnerAddr);
                this.createPartnerAddress(partner, partnerAddr);
            } else if (Strings.isNullOrEmpty((String)partner.getDescription()) || partner.getDescription() != null && !partner.getDescription().contains(googleAddr.getStreetAddress())) {
                this.updateDescription(partner, I18n.get((String)SYNC_CONTACT_GOOGLE_ADDR), googleAddr.getFormattedValue());
            }
        }
    }

    protected void createPartnerAddress(Partner partner, Address partnerAddr) {
        PartnerAddress partnerAddress = new PartnerAddress();
        partnerAddress.setAddress(partnerAddr);
        partnerAddress.setImportOrigin(this.importOrigin);
        partnerAddress.setPartner(partner);
        partnerAddress.setIsDefaultAddr(true);
        partnerAddress.setIsDeliveryAddr(true);
        partnerAddress.setIsInvoicingAddr(true);
    }

    protected Address createAddress(com.google.api.services.people.v1.model.Address googleAddr) {
        Address partnerAddr = new Address();
        Country partnerCountry = this.countryRepo.findByName(googleAddr.getCountry());
        if (partnerCountry == null) {
            partnerCountry = this.createCountry(googleAddr.getCountry(), googleAddr.getCountryCode());
        }
        partnerAddr.setAddressL7Country(partnerCountry);
        if (!Strings.isNullOrEmpty((String)googleAddr.getCity())) {
            City partnerCity = this.cityRepo.findByName(googleAddr.getCity());
            if (partnerCity == null) {
                partnerCity = this.createCity(googleAddr.getCity(), partnerCountry);
            }
            partnerAddr.setCity(partnerCity);
        }
        StringBuilder addrL4 = new StringBuilder();
        if (!Strings.isNullOrEmpty((String)googleAddr.getPoBox())) {
            addrL4.append(googleAddr.getPoBox()).append(" - ");
        }
        partnerAddr.setZip(googleAddr.getPostalCode());
        addrL4.append(googleAddr.getStreetAddress());
        partnerAddr.setAddressL4(addrL4.toString());
        partnerAddr.setAddressL5(googleAddr.getCity());
        partnerAddr.setAddressL2(googleAddr.getExtendedAddress());
        partnerAddr.setAddressL6(googleAddr.getPostalCode() + " " + googleAddr.getCity());
        partnerAddr.setFullName(((AddressService)Beans.get(AddressService.class)).computeFullName(partnerAddr));
        partnerAddr.setImportOrigin(this.importOrigin);
        return partnerAddr;
    }

    protected Country createCountry(String googleCountry, String googleCountryCode) {
        Country country = new Country();
        country.setAlpha2Code(googleCountryCode);
        country.setName(googleCountry);
        country.setImportOrigin(this.importOrigin);
        return (Country)((Object)this.countryRepo.save((Model)((Object)country)));
    }

    protected City createCity(String googleCity, Country country) {
        City city = new City();
        city.setName(googleCity);
        city.setCountry(country);
        city.setImportOrigin(this.importOrigin);
        return (City)((Object)this.cityRepo.save((Model)((Object)city)));
    }

    protected void importPhoneNumber(Person googlePerson, Partner partner, Boolean updateContactField) {
        if (googlePerson.getPhoneNumbers() == null) {
            return;
        }
        PhoneNumber googleNumb = (PhoneNumber)Mapper.toBean(PhoneNumber.class, (Map)((Map)googlePerson.getPhoneNumbers().get(0)));
        if (!Strings.isNullOrEmpty((String)googleNumb.getCanonicalForm())) {
            if (partner.getMobilePhone() == null) {
                partner.setMobilePhone(googleNumb.getCanonicalForm().trim());
            } else if (!partner.getMobilePhone().equals(googleNumb.getCanonicalForm().trim())) {
                if (updateContactField.booleanValue()) {
                    this.updateDescription(partner, I18n.get((String)SYNC_CONTACT_OLD_PHONE_NUMB), partner.getMobilePhone());
                    partner.setMobilePhone(googleNumb.getCanonicalForm().trim());
                } else {
                    this.updateDescription(partner, I18n.get((String)SYNC_CONTACT_GOOGLE_PHONE_NUMB), googleNumb.getCanonicalForm().trim());
                }
            }
        }
    }

    @Transactional(rollbackOn={AxelorException.class, Exception.class})
    public Partner updatePartner(Person googlePerson, Partner partner, Boolean updateContactField) {
        Boolean toUpdate = updateContactField != false && partner.getIsContact() != false && partner.getIsCustomer() == false && partner.getIsSupplier() == false;
        this.updatePartnerFields(googlePerson, partner, toUpdate);
        return (Partner)((Object)this.partnerRepo.save((Model)((Object)partner)));
    }

    protected void updatePartnerFields(Person googlePerson, Partner partner, Boolean updateContactField) {
        this.importEmailAddress(googlePerson, partner, updateContactField);
        this.importAddress(googlePerson, partner, updateContactField);
        this.importPhoneNumber(googlePerson, partner, updateContactField);
    }

    protected void importCompany(Person googlePerson, Partner partner, Boolean updateContactField) {
        if (googlePerson.getOrganizations() == null) {
            return;
        }
        Organization googleCompany = (Organization)Mapper.toBean(Organization.class, (Map)((Map)googlePerson.getOrganizations().get(0)));
        if (!Strings.isNullOrEmpty((String)googleCompany.getName())) {
            Company company = this.companyRepo.findByName(googleCompany.getName().trim());
            if (company == null) {
                this.updateDescription(partner, I18n.get((String)SYNC_CONTACT_COMPANY), googleCompany.getName());
            } else if (partner.getCompanySet() == null || partner.getCompanySet() != null && !partner.getCompanySet().contains((Object)company)) {
                if (company.getPartner() != null) {
                    if (partner.getMainPartner() == null) {
                        partner.setMainPartner(company.getPartner());
                    }
                    company.getPartner().addContactPartnerSetItem(partner);
                }
                partner.addCompanySetItem(company);
            }
        }
        this.importJobTitle(partner, updateContactField, googleCompany);
    }

    protected void importJobTitle(Partner partner, Boolean updateContactField, Organization googleCompany) {
        String jobTitle = googleCompany.getTitle();
        if (!Strings.isNullOrEmpty((String)jobTitle)) {
            Function jobTitleFunction = this.functionRepo.findByName(jobTitle);
            if (partner.getJobTitleFunction() == null) {
                if (jobTitleFunction == null) {
                    jobTitleFunction = this.createJobTitleFunction(jobTitle);
                }
                partner.setJobTitleFunction(jobTitleFunction);
            } else if (partner.getJobTitleFunction() != null && !partner.getJobTitleFunction().equals((Object)jobTitleFunction)) {
                if (updateContactField.booleanValue()) {
                    this.updateDescription(partner, I18n.get((String)SYNC_CONTACT_OLD_JOBTITLE), partner.getJobTitleFunction().getName());
                    if (jobTitleFunction == null) {
                        jobTitleFunction = this.createJobTitleFunction(jobTitle);
                    }
                    partner.setJobTitleFunction(jobTitleFunction);
                } else {
                    this.updateDescription(partner, I18n.get((String)SYNC_CONTACT_NEW_JOBTITLE), jobTitle);
                }
            }
        }
    }

    protected Function createJobTitleFunction(String name) {
        Function function = new Function();
        function.setName(name);
        return (Function)((Object)this.functionRepo.save((Model)((Object)function)));
    }

    protected void updateDescription(Partner partner, String field, String data) {
        String description = this.getPartnerDescription(partner);
        if (!description.contains(data)) {
            description = description + field + ": " + data;
            partner.setDescription(description);
        }
    }

    protected String getPartnerDescription(Partner partner) {
        if (Strings.isNullOrEmpty((String)partner.getDescription())) {
            return "";
        }
        return partner.getDescription().equals("<br>") ? "" : partner.getDescription() + "<br>";
    }
}

