/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.tracking;

import com.axelor.apps.base.db.GlobalTrackingConfigurationLine;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.base.tracking.GlobalTrackingLogService;
import com.axelor.event.Observes;
import com.axelor.events.PostRequest;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.db.MetaModel;
import com.axelor.meta.db.repo.MetaModelRepository;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Path;
import java.util.List;
import java.util.Map;
import javax.inject.Named;
import org.apache.commons.collections.CollectionUtils;

public class ExportObserver {
    void onExport(@Observes @Named(value="export") PostRequest event) throws IOException {
        List<GlobalTrackingConfigurationLine> gtcLines = ((AppBaseService)Beans.get(AppBaseService.class)).getAppBase().getGlobalTrackingConfigurationLines();
        if (CollectionUtils.isEmpty(gtcLines)) {
            return;
        }
        MetaModel model = (MetaModel)((MetaModelRepository)Beans.get(MetaModelRepository.class)).all().filter("self.fullName = ?", new Object[]{event.getRequest().getBeanClass().getName()}).fetchOne();
        if (gtcLines.stream().anyMatch(l -> l.getMetaModel().equals((Object)model) && l.getTrackExport() != false)) {
            Map data = (Map)event.getResponse().getData();
            if (data == null || data.get("fileName") == null) {
                return;
            }
            String fileName = (String)data.get("fileName");
            Path filePath = MetaFiles.findTempFile((String)fileName);
            MetaFile mf = new MetaFile();
            mf.setFileName(fileName);
            ((MetaFiles)Beans.get(MetaFiles.class)).upload((InputStream)new FileInputStream(filePath.toFile()), mf);
            ((GlobalTrackingLogService)Beans.get(GlobalTrackingLogService.class)).createExportLog(model, mf);
        }
    }
}

