/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.tracking;

import com.axelor.apps.base.db.GlobalTrackingConfigurationLine;
import com.axelor.apps.base.db.GlobalTrackingLog;
import com.axelor.apps.base.db.GlobalTrackingLogLine;
import com.axelor.apps.base.db.repo.GlobalTrackingConfigurationLineRepository;
import com.axelor.apps.base.db.repo.GlobalTrackingLogRepository;
import com.axelor.apps.base.tracking.GlobalAuditInterceptor;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.AuditableModel;
import com.axelor.auth.db.User;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.inject.Beans;
import com.axelor.meta.db.MetaField;
import com.axelor.meta.db.repo.MetaFieldRepository;
import com.axelor.meta.db.repo.MetaModelRepository;
import com.axelor.script.GroovyScriptHelper;
import com.axelor.script.ScriptBindings;
import com.google.common.base.Strings;
import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.script.Bindings;
import org.apache.commons.collections.CollectionUtils;
import org.hibernate.Transaction;
import org.hibernate.collection.internal.AbstractPersistentCollection;
import org.hibernate.collection.internal.PersistentBag;
import org.hibernate.collection.internal.PersistentSet;

public class GlobalAuditTracker {
    private static final ThreadLocal<List<GlobalTrackingLog>> LOGS = new ThreadLocal();

    public void onComplete(Transaction tx, User user) {
        List<GlobalTrackingLog> logList = LOGS.get();
        LOGS.remove();
        if (CollectionUtils.isEmpty(logList)) {
            return;
        }
        MetaModelRepository modelRepo = (MetaModelRepository)Beans.get(MetaModelRepository.class);
        MetaFieldRepository fieldRepo = (MetaFieldRepository)((Object)Beans.get(MetaFieldRepository.class));
        GlobalTrackingLogRepository logRepo = (GlobalTrackingLogRepository)((Object)Beans.get(GlobalTrackingLogRepository.class));
        GlobalTrackingConfigurationLineRepository configLineRepo = (GlobalTrackingConfigurationLineRepository)((Object)Beans.get(GlobalTrackingConfigurationLineRepository.class));
        for (GlobalTrackingLog log : logList) {
            List configLineList = configLineRepo.all().filter("self.metaModel.name = ?", new Object[]{log.getMetaModelName()}).fetch();
            if (configLineList.isEmpty()) continue;
            log.setMetaModel(modelRepo.findByName(log.getMetaModelName()));
            ArrayList<GlobalTrackingLogLine> logLinesToSave = new ArrayList<GlobalTrackingLogLine>();
            if (CollectionUtils.isNotEmpty(log.getGlobalTrackingLogLineList())) {
                ScriptBindings bindings;
                try {
                    bindings = new ScriptBindings(this.getContext(JPA.find(Class.forName(log.getMetaModel().getFullName()), (Long)log.getRelatedId())));
                }
                catch (Exception e) {
                    continue;
                }
                for (GlobalTrackingLogLine line : log.getGlobalTrackingLogLineList()) {
                    GlobalTrackingConfigurationLine configLine = configLineList.stream().filter(l -> l.getMetaField().getName().equals(line.getMetaFieldName())).findFirst().orElse(null);
                    if (configLine == null || !this.canTrack(configLine, log.getTypeSelect()) || !Strings.isNullOrEmpty((String)configLine.getTrackingCondition()) && !Boolean.TRUE.equals(new GroovyScriptHelper((Bindings)bindings).eval(configLine.getTrackingCondition()))) continue;
                    line.setMetaField((MetaField)((Object)fieldRepo.all().filter("self.metaModel.id = ? AND self.name = ?", new Object[]{log.getMetaModel().getId(), line.getMetaFieldName()}).fetchOne()));
                    logLinesToSave.add(line);
                }
            }
            if (logLinesToSave.isEmpty() && (4 != log.getTypeSelect() || !configLineList.stream().anyMatch(l -> Boolean.TRUE.equals(l.getTrackDeletion())))) continue;
            log.getGlobalTrackingLogLineList().stream().forEach(l -> l.setGlobalTrackingLog(null));
            logLinesToSave.stream().forEach(l -> l.setGlobalTrackingLog(log));
            log.setUser(user);
            logRepo.save((Model)((Object)log));
        }
    }

    private boolean canTrack(GlobalTrackingConfigurationLine confLine, int typeSelect) {
        switch (typeSelect) {
            case 1: {
                return confLine.getTrackCreation();
            }
            case 2: {
                return confLine.getTrackReading();
            }
            case 3: {
                return confLine.getTrackUpdate();
            }
            case 4: {
                return confLine.getTrackDeletion();
            }
            case 5: {
                return confLine.getTrackExport();
            }
        }
        return false;
    }

    private Map<String, Object> getContext(Object obj) throws IntrospectionException, InvocationTargetException, IllegalAccessException, IllegalArgumentException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        BeanInfo info = Introspector.getBeanInfo(obj.getClass());
        Method reader = null;
        for (PropertyDescriptor pd : info.getPropertyDescriptors()) {
            reader = pd.getReadMethod();
            if (reader == null) continue;
            result.put(pd.getName(), reader.invoke(obj, new Object[0]));
        }
        return result;
    }

    protected void init() {
        LOGS.set(new ArrayList());
    }

    protected void clear() {
        LOGS.remove();
    }

    protected void addLog(GlobalTrackingLog log) {
        if (LOGS.get() == null) {
            this.init();
        }
        LOGS.get().add(log);
    }

    protected GlobalTrackingLog addLog(AuditableModel entity, int type) {
        GlobalTrackingLog log = new GlobalTrackingLog();
        log.setDateT(LocalDateTime.now());
        log.setMetaModelName(entity.getClass().getSimpleName());
        log.setTypeSelect(type);
        log.setUser(AuthUtils.getUser());
        log.setRelatedId(entity.getId());
        log.setGlobalTrackingLogLineList(new ArrayList<GlobalTrackingLogLine>());
        this.addLog(log);
        return log;
    }

    protected void addCollectionModification(Object collection, Long id) {
        if (collection instanceof AbstractPersistentCollection) {
            PersistentSet newValues = null;
            Collection<Object> oldValues = null;
            if (collection instanceof PersistentSet) {
                newValues = (PersistentSet)collection;
                oldValues = ((Map)((Object)newValues.getStoredSnapshot())).keySet();
            } else if (collection instanceof PersistentBag) {
                newValues = (PersistentBag)collection;
                oldValues = (Collection)((Object)newValues.getStoredSnapshot());
            }
            if (newValues == null) {
                return;
            }
            Object owner = newValues.getOwner();
            if (owner == null || Arrays.asList(GlobalAuditInterceptor.BACKLISTED_CLASSES).contains(owner.getClass()) || !(owner instanceof AuditableModel)) {
                return;
            }
            String fieldName = newValues.getRole().replace(owner.getClass().getCanonicalName() + ".", "");
            GlobalTrackingLog log = LOGS.get().stream().filter(l -> l.getRelatedId().equals(id) && l.getMetaModelName().equals(owner.getClass().getSimpleName())).findFirst().orElse(this.addLog((AuditableModel)owner, 3));
            ArrayList<Long> previousIdList = new ArrayList<Long>();
            ArrayList<Long> newIdList = new ArrayList<Long>();
            if (CollectionUtils.isNotEmpty(oldValues)) {
                for (AuditableModel auditableModel : oldValues) {
                    if (auditableModel == null) continue;
                    previousIdList.add(auditableModel.getId());
                }
            }
            for (AuditableModel auditableModel : (Collection)newValues) {
                if (auditableModel == null) continue;
                newIdList.add(auditableModel.getId());
            }
            GlobalTrackingLogLine line = log.getGlobalTrackingLogLineList().stream().filter(l -> l.getMetaFieldName().equals(fieldName)).findFirst().orElse(null);
            if (line == null) {
                line = new GlobalTrackingLogLine();
                line.setMetaFieldName(fieldName);
                line.setGlobalTrackingLog(log);
                line.setPreviousValue(String.format("[%s]", previousIdList.stream().map(String::valueOf).collect(Collectors.joining(", "))));
                log.addGlobalTrackingLogLineListItem(line);
            }
            line.setNewValue(String.format("[%s]", newIdList.stream().map(String::valueOf).collect(Collectors.joining(", "))));
        }
    }
}

