/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.tracking;

import com.axelor.apps.base.db.GlobalTrackingLog;
import com.axelor.apps.base.db.repo.GlobalTrackingLogRepository;
import com.axelor.apps.base.tracking.GlobalTrackingLogService;
import com.axelor.auth.AuthUtils;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.db.Query;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.db.MetaModel;
import com.axelor.meta.db.repo.MetaFileRepository;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.io.File;
import java.time.LocalDateTime;
import java.util.List;

public class GlobalTrackingLogServiceImpl
implements GlobalTrackingLogService {
    protected GlobalTrackingLogRepository globalTrackingLogRepo;
    protected MetaFileRepository metaFileRepo;

    @Inject
    public GlobalTrackingLogServiceImpl(GlobalTrackingLogRepository globalTrackingLogRepo, MetaFileRepository metaFileRepo) {
        this.globalTrackingLogRepo = globalTrackingLogRepo;
        this.metaFileRepo = metaFileRepo;
    }

    @Override
    @Transactional(rollbackOn={Exception.class})
    public GlobalTrackingLog createExportLog(MetaModel model, MetaFile metaFile) {
        GlobalTrackingLog log = new GlobalTrackingLog();
        log.setDateT(LocalDateTime.now());
        log.setMetaModel(model);
        log.setTypeSelect(5);
        log.setUser(AuthUtils.getUser());
        log.setMetaFile(metaFile);
        return (GlobalTrackingLog)((Object)this.globalTrackingLogRepo.save((Model)((Object)log)));
    }

    @Override
    public void deleteOldGlobalTrackingLog(int months) {
        List globalTrackingLogList;
        int FETCH_LIMIT = 5;
        Query query = this.globalTrackingLogRepo.all().filter("self.createdOn <= :dateLimit").bind("dateLimit", (Object)LocalDateTime.now().minusMonths(months));
        while (!(globalTrackingLogList = query.fetch(5)).isEmpty()) {
            this.removeGlobalTrackingLogs(globalTrackingLogList);
            JPA.clear();
        }
    }

    @Override
    @Transactional
    public void removeGlobalTrackingLogs(List<GlobalTrackingLog> globalTrackingLogList) {
        for (GlobalTrackingLog globalTrackingLog : globalTrackingLogList) {
            MetaFile metaFile = globalTrackingLog.getMetaFile();
            this.globalTrackingLogRepo.remove((Model)((Object)globalTrackingLog));
            if (globalTrackingLog.getMetaFile() == null) continue;
            File metaFileFile = new File(globalTrackingLog.getMetaFile().getFilePath());
            metaFileFile.delete();
            this.metaFileRepo.remove((Model)metaFile);
        }
        JPA.flush();
    }
}

