/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.web;

import com.axelor.apps.base.db.AdvancedExport;
import com.axelor.apps.base.db.repo.AdvancedExportRepository;
import com.axelor.apps.base.service.advancedExport.AdvancedExportService;
import com.axelor.common.Inflector;
import com.axelor.db.mapper.Mapper;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaField;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.db.MetaModel;
import com.axelor.meta.db.repo.MetaFieldRepository;
import com.axelor.meta.db.repo.MetaModelRepository;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.axelor.rpc.filter.Filter;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.inject.Singleton;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class AdvancedExportController {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private Inflector inflector;

    public void getModelAllFields(ActionRequest request, ActionResponse response) throws ClassNotFoundException {
        AdvancedExport advancedExport = (AdvancedExport)((Object)request.getContext().asType(AdvancedExport.class));
        this.inflector = Inflector.getInstance();
        if (advancedExport.getMetaModel() != null) {
            ArrayList allFieldList = new ArrayList();
            MetaModelRepository metaModelRepository = (MetaModelRepository)Beans.get(MetaModelRepository.class);
            MetaFieldRepository metaFieldRepository = (MetaFieldRepository)((Object)Beans.get(MetaFieldRepository.class));
            for (MetaField field : advancedExport.getMetaModel().getMetaFields()) {
                HashMap<String, Object> allFieldMap = new HashMap<String, Object>();
                allFieldMap.put("currentDomain", advancedExport.getMetaModel().getName());
                if (!Strings.isNullOrEmpty((String)field.getRelationship())) {
                    MetaModel metaModel = (MetaModel)metaModelRepository.all().filter("self.name = ?", new Object[]{field.getTypeName()}).fetchOne();
                    Class<?> klass = Class.forName(metaModel.getFullName());
                    Mapper mapper = Mapper.of(klass);
                    String fieldName = mapper.getNameField() == null ? "id" : mapper.getNameField().getName();
                    MetaField metaField = (MetaField)((Object)metaFieldRepository.all().filter("self.name = ?1 AND self.metaModel = ?2", new Object[]{fieldName, metaModel}).fetchOne());
                    allFieldMap.put("metaField", (Object)metaField);
                    allFieldMap.put("targetField", field.getName() + "." + metaField.getName());
                } else {
                    allFieldMap.put("metaField", (Object)field);
                    allFieldMap.put("targetField", field.getName());
                }
                if (Strings.isNullOrEmpty((String)field.getLabel())) {
                    allFieldMap.put("title", this.getFieldTitle(this.inflector, field.getName()));
                } else {
                    allFieldMap.put("title", field.getLabel());
                }
                allFieldList.add(allFieldMap);
            }
            response.setAttr("advancedExportLineList", "value", allFieldList);
        }
    }

    public void fillTitle(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        MetaField metaField = (MetaField)((Object)context.get((Object)"metaField"));
        if (metaField != null) {
            if (Strings.isNullOrEmpty((String)metaField.getLabel())) {
                this.inflector = Inflector.getInstance();
                response.setValue("title", (Object)I18n.get((String)this.getFieldTitle(this.inflector, metaField.getName())));
            } else {
                response.setValue("title", (Object)I18n.get((String)metaField.getLabel()));
            }
        } else {
            response.setValue("title", null);
        }
    }

    private String getFieldTitle(Inflector inflector, String fieldName) {
        return inflector.humanize(fieldName);
    }

    public void fillTargetField(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        MetaField metaField = (MetaField)((Object)context.get((Object)"metaField"));
        if (metaField != null) {
            String targetField = "";
            if (context.get((Object)"targetField") == null) {
                targetField = metaField.getName();
            } else {
                targetField = context.get((Object)"targetField").toString();
                targetField = targetField + "." + metaField.getName();
            }
            response.setValue("targetField", (Object)targetField);
            if (metaField.getRelationship() != null) {
                response.setValue("currentDomain", (Object)metaField.getTypeName());
                response.setValue("metaField", null);
            } else {
                response.setAttr("metaField", "readonly", (Object)true);
                response.setAttr("validateFieldSelectionBtn", "readonly", (Object)true);
                response.setAttr("$viewerMessage", "hidden", (Object)false);
                response.setAttr("$isValidate", "value", (Object)true);
            }
        }
    }

    public void advancedExportPDF(ActionRequest request, ActionResponse response) {
        try {
            this.advancedExport(request, response, "PDF");
        }
        catch (AxelorException | IOException e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void advancedExportExcel(ActionRequest request, ActionResponse response) {
        try {
            this.advancedExport(request, response, "EXCEL");
        }
        catch (AxelorException | IOException e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void advancedExportCSV(ActionRequest request, ActionResponse response) {
        try {
            this.advancedExport(request, response, "CSV");
        }
        catch (AxelorException | IOException e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    private void advancedExport(ActionRequest request, ActionResponse response, String fileType) throws AxelorException, IOException {
        AdvancedExport advancedExport = (AdvancedExport)((Object)request.getContext().asType(AdvancedExport.class));
        advancedExport = (AdvancedExport)((Object)((AdvancedExportRepository)((Object)Beans.get(AdvancedExportRepository.class))).find(advancedExport.getId()));
        this.getAdvancedExportFile(request, response, advancedExport, fileType);
    }

    private void getAdvancedExportFile(ActionRequest request, ActionResponse response, AdvancedExport advancedExport, String fileType) throws AxelorException, IOException {
        AdvancedExportService advancedExportService = (AdvancedExportService)Beans.get(AdvancedExportService.class);
        if (!advancedExport.getAdvancedExportLineList().isEmpty()) {
            List<Long> recordIds = this.createCriteria(request, advancedExport);
            File file = advancedExportService.export(advancedExport, recordIds, fileType);
            if (advancedExportService.getIsReachMaxExportLimit()) {
                response.setFlash(I18n.get((String)"Warning : Exported maximum export limit records."));
            }
            FileInputStream inStream = new FileInputStream(file);
            MetaFile exportFile = ((MetaFiles)Beans.get(MetaFiles.class)).upload((InputStream)inStream, advancedExportService.getExportFileName());
            inStream.close();
            file.delete();
            this.downloadExportFile(response, exportFile);
        } else {
            response.setError(I18n.get((String)"Please select fields for export."));
        }
    }

    private List<Long> createCriteria(ActionRequest request, AdvancedExport advancedExport) {
        if (request.getContext().get((Object)"_criteria") != null) {
            if (request.getContext().get((Object)"_criteria").toString().startsWith("[")) {
                String ids = request.getContext().get((Object)"_criteria").toString();
                return Splitter.on((String)", ").splitToList((CharSequence)ids.substring(1, ids.length() - 1)).stream().map(id -> Long.valueOf(id.toString())).collect(Collectors.toList());
            }
            ObjectMapper mapper = new ObjectMapper();
            ActionRequest parentRequest = (ActionRequest)mapper.convertValue(request.getContext().get((Object)"_criteria"), ActionRequest.class);
            Class klass = parentRequest.getBeanClass();
            Filter filter = ((AdvancedExportService)Beans.get(AdvancedExportService.class)).getJpaSecurityFilter(advancedExport.getMetaModel());
            Stream listObj = parentRequest.getCriteria().createQuery(klass, filter).fetchSteam(advancedExport.getMaxExportLimit().intValue());
            return listObj.map(it -> it.getId()).collect(Collectors.toList());
        }
        return null;
    }

    public void callAdvancedExportWizard(ActionRequest request, ActionResponse response) throws ClassNotFoundException {
        LOG.debug("Call advanced export wizard for model : {} ", (Object)request.getModel());
        MetaModel metaModel = (MetaModel)((MetaModelRepository)Beans.get(MetaModelRepository.class)).all().filter("self.fullName = ?", new Object[]{request.getModel()}).fetchOne();
        String criteria = "";
        if (request.getContext().get((Object)"_ids") != null) {
            criteria = request.getContext().get((Object)"_ids").toString();
        } else {
            Class klass = request.getBeanClass();
            Filter filter = ((AdvancedExportService)Beans.get(AdvancedExportService.class)).getJpaSecurityFilter(metaModel);
            int recordCount = (int)request.getCriteria().createQuery(klass, filter).count();
            if (recordCount > 0) {
                criteria = String.valueOf(recordCount);
            }
        }
        if (Strings.isNullOrEmpty((String)criteria)) {
            response.setError(I18n.get((String)"There is no records to export."));
        } else {
            response.setView(ActionView.define((String)I18n.get((String)"Advanced export")).model(AdvancedExport.class.getName()).add("form", "advanced-export-wizard-form").param("popup", "true").param("show-toolbar", "false").param("show-confirm", "false").param("popup-save", "false").context("_metaModel", (Object)metaModel).context("_criteria", (Object)(criteria.startsWith("[") ? criteria : request)).map());
        }
    }

    public void generateExportFile(ActionRequest request, ActionResponse response) {
        try {
            if (request.getContext().get((Object)"_xAdvancedExport") == null || request.getContext().get((Object)"exportFormatSelect") == null) {
                response.setError(I18n.get((String)"Please select export object or export format."));
                return;
            }
            AdvancedExport advancedExport = (AdvancedExport)((Object)((AdvancedExportRepository)((Object)Beans.get(AdvancedExportRepository.class))).find(Long.valueOf(((Map)request.getContext().get((Object)"_xAdvancedExport")).get("id").toString())));
            String fileType = request.getContext().get((Object)"exportFormatSelect").toString();
            this.getAdvancedExportFile(request, response, advancedExport, fileType);
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    private void downloadExportFile(ActionResponse response, MetaFile exportFile) {
        if (exportFile != null) {
            response.setView(ActionView.define((String)I18n.get((String)"Export file")).model(AdvancedExport.class.getName()).add("html", "ws/rest/com.axelor.meta.db.MetaFile/" + exportFile.getId() + "/content/download?v=" + exportFile.getVersion()).param("download", "true").map());
        }
    }
}

