/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.web;

import com.axelor.apps.base.db.AdvancedImport;
import com.axelor.apps.base.db.repo.AdvancedImportRepository;
import com.axelor.apps.base.service.advanced.imports.AdvancedImportService;
import com.axelor.apps.base.service.advanced.imports.DataImportService;
import com.axelor.apps.base.service.advanced.imports.ValidatorService;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.db.MetaFile;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;

public class AdvancedImportController {
    public void apply(ActionRequest request, ActionResponse response) throws AxelorException {
        try {
            boolean isValid;
            AdvancedImport advancedImport = (AdvancedImport)((Object)request.getContext().asType(AdvancedImport.class));
            if (advancedImport.getId() != null) {
                advancedImport = (AdvancedImport)((Object)((AdvancedImportRepository)((Object)Beans.get(AdvancedImportRepository.class))).find(advancedImport.getId()));
            }
            if (isValid = ((AdvancedImportService)Beans.get(AdvancedImportService.class)).apply(advancedImport)) {
                response.setReload(true);
            } else {
                response.setFlash(I18n.get((String)"Data file format is invalid"));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void validate(ActionRequest request, ActionResponse response) {
        try {
            boolean isLog;
            AdvancedImport advancedImport = (AdvancedImport)((Object)request.getContext().asType(AdvancedImport.class));
            if (advancedImport.getId() != null) {
                advancedImport = (AdvancedImport)((Object)((AdvancedImportRepository)((Object)Beans.get(AdvancedImportRepository.class))).find(advancedImport.getId()));
            }
            if (isLog = ((ValidatorService)Beans.get(ValidatorService.class)).validate(advancedImport)) {
                response.setFlash(I18n.get((String)"Check log file in tabs configuration"));
                response.setReload(true);
            } else {
                response.setValue("statusSelect", (Object)1);
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void importData(ActionRequest request, ActionResponse response) {
        try {
            MetaFile logFile;
            AdvancedImport advancedImport = (AdvancedImport)((Object)request.getContext().asType(AdvancedImport.class));
            if (advancedImport.getId() != null) {
                advancedImport = (AdvancedImport)((Object)((AdvancedImportRepository)((Object)Beans.get(AdvancedImportRepository.class))).find(advancedImport.getId()));
            }
            if ((logFile = ((DataImportService)Beans.get(DataImportService.class)).importData(advancedImport)) != null) {
                response.setValue("errorLog", (Object)logFile);
            } else {
                response.setValue("errorLog", null);
                response.setFlash(I18n.get((String)"Data imported successfully"));
                response.setSignal("refresh-app", (Object)true);
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void resetImport(ActionRequest request, ActionResponse response) {
        try {
            boolean isReset;
            AdvancedImport advancedImport = (AdvancedImport)((Object)request.getContext().asType(AdvancedImport.class));
            if (advancedImport.getId() != null) {
                advancedImport = (AdvancedImport)((Object)((AdvancedImportRepository)((Object)Beans.get(AdvancedImportRepository.class))).find(advancedImport.getId()));
            }
            if (isReset = ((AdvancedImportService)Beans.get(AdvancedImportService.class)).resetImport(advancedImport)) {
                response.setFlash(I18n.get((String)"Reset imported data successfully"));
                response.setSignal("refresh-app", (Object)true);
            } else {
                response.setFlash(I18n.get((String)"No imported data to reset"));
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

