/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.web;

import com.axelor.app.AppSettings;
import com.axelor.apps.base.db.AppBase;
import com.axelor.apps.base.service.CurrencyConversionService;
import com.axelor.apps.base.service.MapService;
import com.axelor.apps.base.service.administration.ExportDbObjectService;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;

@Singleton
public class AppBaseController {
    public void exportObjects(ActionRequest request, ActionResponse response) {
        MetaFile metaFile = ((ExportDbObjectService)Beans.get(ExportDbObjectService.class)).exportObject();
        if (metaFile == null) {
            response.setFlash(I18n.get((String)"Attachment directory OR Application source does not exist"));
        } else {
            response.setView(ActionView.define((String)I18n.get((String)"Export Object")).model("com.axelor.meta.db.MetaFile").add("form", "meta-files-form").add("grid", "meta-files-grid").param("forceEdit", "true").context("_showRecord", (Object)metaFile.getId().toString()).map());
        }
    }

    public void checkMapApi(ActionRequest request, ActionResponse response) {
        try {
            AppBase appBase = (AppBase)((Object)request.getContext().asType(AppBase.class));
            Integer apiType = appBase.getMapApiSelect();
            if (apiType == 1) {
                ((MapService)Beans.get(MapService.class)).testGMapService();
                response.setFlash("Connection successful");
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void updateCurrencyConversion(ActionRequest request, ActionResponse response) throws AxelorException {
        ((CurrencyConversionService)Beans.get(CurrencyConversionService.class)).updateCurrencyConverion();
        response.setReload(true);
    }

    public void applyApplicationMode(ActionRequest request, ActionResponse response) {
        String applicationMode = AppSettings.get().get("application.mode", "prod");
        if ("dev".equals(applicationMode)) {
            response.setAttr("mainPanel", "hidden", (Object)false);
        }
    }

    public void showCustomersOnMap(ActionRequest request, ActionResponse response) {
        try {
            response.setView(ActionView.define((String)I18n.get((String)"Customers")).add("html", ((MapService)Beans.get(MapService.class)).getMapURI("customer")).map());
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
    }

    public void showProspectsOnMap(ActionRequest request, ActionResponse response) {
        try {
            response.setView(ActionView.define((String)I18n.get((String)"Prospects")).add("html", ((MapService)Beans.get(MapService.class)).getMapURI("prospect")).map());
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
    }

    public void showSuppliersOnMap(ActionRequest request, ActionResponse response) {
        try {
            response.setView(ActionView.define((String)I18n.get((String)"Suppliers")).add("html", ((MapService)Beans.get(MapService.class)).getMapURI("supplier")).map());
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
    }
}

