/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.web;

import com.axelor.apps.base.db.Currency;
import com.axelor.apps.base.db.CurrencyConversionLine;
import com.axelor.apps.base.db.repo.CurrencyConversionLineRepository;
import com.axelor.apps.base.db.repo.CurrencyRepository;
import com.axelor.apps.base.service.CurrencyConversionService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.inject.Singleton;
import java.lang.invoke.MethodHandles;
import java.math.BigDecimal;
import java.net.MalformedURLException;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import wslite.json.JSONException;

@Singleton
public class CurrencyConversionLineController {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void checkDate(ActionRequest request, ActionResponse response) {
        CurrencyConversionLine ccl = (CurrencyConversionLine)((Object)request.getContext().asType(CurrencyConversionLine.class));
        LOG.debug("Currency Conversion Line Id : {}", (Object)ccl.getId());
        if (ccl.getId() != null && ((CurrencyConversionLineRepository)((Object)Beans.get(CurrencyConversionLineRepository.class))).all().filter("self.startCurrency.id = ?1 and self.endCurrency.id = ?2 and (self.toDate = null OR  self.toDate >= ?3) and self.id != ?4)", new Object[]{ccl.getStartCurrency().getId(), ccl.getEndCurrency().getId(), ccl.getFromDate(), ccl.getId()}).count() > 0L) {
            response.setFlash(I18n.get((String)"WARNING : please close the current conversion period to create a new one."));
        } else if (ccl.getId() == null && ((CurrencyConversionLineRepository)((Object)Beans.get(CurrencyConversionLineRepository.class))).all().filter("self.startCurrency.id = ?1 and self.endCurrency.id = ?2 and (self.toDate = null OR  self.toDate >= ?3))", new Object[]{ccl.getStartCurrency().getId(), ccl.getEndCurrency().getId(), ccl.getFromDate()}).count() > 0L) {
            response.setFlash(I18n.get((String)"WARNING : please close the current conversion period to create a new one."));
        }
        if (ccl.getFromDate() != null && ccl.getToDate() != null && ccl.getFromDate().isAfter(ccl.getToDate())) {
            response.setFlash(I18n.get((String)"The end date has to be greater than or equal to the start date."));
        }
    }

    public void convert(ActionRequest request, ActionResponse response) throws MalformedURLException, JSONException, AxelorException {
        Context context = request.getContext();
        Currency fromCurrency = null;
        Currency toCurrency = null;
        CurrencyRepository currencyRepository = (CurrencyRepository)((Object)Beans.get(CurrencyRepository.class));
        if (context.get((Object)"startCurrency") instanceof Currency) {
            fromCurrency = (Currency)((Object)context.get((Object)"startCurrency"));
            toCurrency = (Currency)((Object)context.get((Object)"endCurrency"));
        } else {
            Map startCurrency = (Map)context.get((Object)"startCurrency");
            Map endCurrency = (Map)context.get((Object)"endCurrency");
            fromCurrency = (Currency)((Object)currencyRepository.find(Long.parseLong(startCurrency.get("id").toString())));
            toCurrency = (Currency)((Object)currencyRepository.find(Long.parseLong(endCurrency.get("id").toString())));
        }
        CurrencyConversionLine prevLine = null;
        if (fromCurrency != null && toCurrency != null) {
            prevLine = context.get((Object)"id") != null ? (CurrencyConversionLine)((Object)((CurrencyConversionLineRepository)((Object)Beans.get(CurrencyConversionLineRepository.class))).all().filter("startCurrency.id = ?1 AND endCurrency.id = ?2 AND id != ?3", new Object[]{fromCurrency.getId(), toCurrency.getId(), context.get((Object)"id")}).order("-fromDate").fetchOne()) : (CurrencyConversionLine)((Object)((CurrencyConversionLineRepository)((Object)Beans.get(CurrencyConversionLineRepository.class))).all().filter("startCurrency.id = ?1 AND endCurrency.id = ?2", new Object[]{fromCurrency.getId(), toCurrency.getId()}).order("-fromDate").fetchOne());
            LOG.debug("Previous currency conversion line: {}", (Object)prevLine);
            fromCurrency = (Currency)((Object)currencyRepository.find(fromCurrency.getId()));
            toCurrency = (Currency)((Object)currencyRepository.find(toCurrency.getId()));
            try {
                BigDecimal rate = ((CurrencyConversionService)Beans.get(CurrencyConversionService.class)).convert(fromCurrency, toCurrency);
                if (rate.compareTo(new BigDecimal(-1)) == 0) {
                    response.setFlash(I18n.get((String)"Currency conversion webservice not working"));
                } else {
                    response.setValue("variations", (Object)"0");
                    if (context.get((Object)"_model").equals("com.axelor.apps.base.db.Wizard")) {
                        response.setValue("newExchangeRate", (Object)rate);
                    } else {
                        response.setValue("exchangeRate", (Object)rate);
                    }
                    response.setValue("fromDate", (Object)((AppBaseService)Beans.get(AppBaseService.class)).getTodayDateTime());
                    if (prevLine != null) {
                        response.setValue("variations", (Object)((CurrencyConversionService)Beans.get(CurrencyConversionService.class)).getVariations(rate, prevLine.getExchangeRate()));
                    }
                }
            }
            catch (AxelorException axelorException) {
                response.setFlash(axelorException.getMessage());
                response.setCanClose(true);
            }
        }
    }
}

