/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.web;

import com.axelor.apps.base.db.Wizard;
import com.axelor.apps.base.service.DuplicateObjectsService;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.common.base.Joiner;
import com.google.inject.Singleton;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class DuplicateObjectsController {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void removeDuplicate(ActionRequest request, ActionResponse response) {
        ArrayList<Long> selectedIds = new ArrayList<Long>();
        String originalId = ((Map)request.getContext().get((Object)"originalObject")).get("recordId").toString();
        selectedIds.add(Long.parseLong(originalId));
        List duplicateObjects = (List)request.getContext().get((Object)"duplicateObjects");
        for (Map map : duplicateObjects) {
            if (map.get("recordId").toString().equals(originalId)) continue;
            selectedIds.add(Long.parseLong(map.get("recordId").toString()));
        }
        String model = request.getContext().get((Object)"_modelName").toString();
        String modelName = model.substring(model.lastIndexOf(".") + 1, model.length());
        ((DuplicateObjectsService)Beans.get(DuplicateObjectsService.class)).removeDuplicate(selectedIds, modelName);
        response.setCanClose(true);
    }

    public void defaultObjects(ActionRequest request, ActionResponse response) throws NoSuchFieldException, SecurityException {
        ArrayList<Long> selectedIds = new ArrayList<Long>();
        ArrayList<Object[]> duplicateObjects = new ArrayList<Object[]>();
        ArrayList<Wizard> wizardDataList = new ArrayList<Wizard>();
        DuplicateObjectsService duplicateObjectsService = (DuplicateObjectsService)Beans.get(DuplicateObjectsService.class);
        for (Integer id : (List)request.getContext().get((Object)"_ids")) {
            selectedIds.add(Long.parseLong("" + id));
        }
        String modelName = request.getContext().get((Object)"_modelName").toString();
        List<Object> duplicateObj = duplicateObjectsService.getAllSelectedObject(selectedIds, modelName);
        for (Object object : duplicateObj) {
            Long id = (Long)Mapper.of(object.getClass()).get(object, "id");
            Property propertyNameColumn = Mapper.of(object.getClass()).getNameField();
            String nameColumn = propertyNameColumn == null ? null : propertyNameColumn.getName().toString();
            Property propertyCode = Mapper.of(object.getClass()).getProperty("code");
            String code = propertyCode == null ? null : propertyCode.getName().toString();
            String noColumn = null;
            if (nameColumn != null) {
                duplicateObjects.add((Object[])duplicateObjectsService.getWizardValue(id, modelName, nameColumn));
                continue;
            }
            if (code != null) {
                duplicateObjects.add((Object[])duplicateObjectsService.getWizardValue(id, modelName, code));
                continue;
            }
            Object obj = duplicateObjectsService.getWizardValue(id, modelName, noColumn);
            Wizard wizard = new Wizard();
            wizard.setRecordId(obj.toString());
            wizard.setName(obj.toString());
            wizardDataList.add(wizard);
        }
        for (Object[] obj : duplicateObjects) {
            String recordName = obj[1].toString();
            String recordId = obj[0].toString();
            Wizard wizard = new Wizard();
            wizard.setRecordId(recordId);
            wizard.setRecordName(recordName);
            wizard.setName(recordName);
            wizardDataList.add(wizard);
        }
        response.setAttr("$duplicateObjects", "value", wizardDataList);
    }

    public void addOriginal(ActionRequest request, ActionResponse response) {
        Context context = request.getContext();
        List duplicateObj = (List)context.get((Object)"duplicateObjects");
        Object originalObj = null;
        Object original = "";
        boolean flag = false;
        for (Map map : duplicateObj) {
            if (!((Boolean)map.get("selected")).booleanValue()) continue;
            originalObj = context.get((Object)"originalObject");
            response.setAttr("$originalObject", "value", (Object)map);
            original = map;
            flag = true;
        }
        if (!flag) {
            response.setAlert(I18n.get((String)"Please select original object."));
        }
        duplicateObj.remove(original);
        if (originalObj != null) {
            duplicateObj.add((Map)originalObj);
        }
        response.setAttr("$duplicateObjects", "value", (Object)duplicateObj);
    }

    public void showDuplicate(ActionRequest request, ActionResponse response) throws AxelorException {
        Context context = request.getContext();
        HashSet<String> fields = new HashSet<String>();
        Class<? extends Model> modelClass = this.extractModel(request, fields);
        LOG.debug("Duplicate record model: {}", (Object)modelClass.getName());
        if (fields.size() > 0) {
            String filter = this.findDuplicated(request, fields, modelClass);
            if (filter == null) {
                response.setFlash(I18n.get((String)"No duplicate records found"));
            } else {
                response.setView(ActionView.define((String)I18n.get((String)"Duplicate records")).model(modelClass.getName()).add("grid").add("form").domain(filter).context("_domain", (Object)filter).map());
                if (context.get((Object)"_contextModel") != null) {
                    response.setCanClose(true);
                }
            }
        } else if (context.get((Object)"_contextModel") == null) {
            response.setFlash(I18n.get((String)"No duplicate finder field configured."));
        } else {
            response.setFlash(I18n.get((String)"Please select key fields to check duplicate"));
        }
    }

    private String findDuplicated(ActionRequest request, Set<String> fields, Class<? extends Model> modelClass) throws AxelorException {
        LOG.debug("Duplicate finder fields: {}", fields);
        List<?> ids = ((DuplicateObjectsService)Beans.get(DuplicateObjectsService.class)).findDuplicatedRecordIds(fields, modelClass, this.getCriteria(request, modelClass));
        if (ids.isEmpty()) {
            return null;
        }
        return "self.id in (" + Joiner.on((String)",").join(ids) + ")";
    }

    private Class<? extends Model> extractModel(ActionRequest request, Set<String> fields) {
        Context context = request.getContext();
        String model = (String)context.get((Object)"_contextModel");
        if (model == null) {
            model = request.getModel();
            String duplicateFinderFields = (String)context.get((Object)"_duplicateFinderFields");
            if (duplicateFinderFields != null) {
                fields.addAll(Arrays.asList(duplicateFinderFields.split(";")));
            }
        } else if (context.get((Object)"fieldsSet") != null) {
            List fieldsSet = (List)context.get((Object)"fieldsSet");
            for (HashMap field : fieldsSet) {
                fields.add((String)field.get("name"));
            }
        }
        return JPA.model((String)model);
    }

    public void callCheckDuplicateWizard(ActionRequest request, ActionResponse response) {
        LOG.debug("Call check duplicate wizard for model : {} ", (Object)request.getModel());
        String criteria = this.getCriteria(request, JPA.model((String)request.getModel()));
        response.setView(ActionView.define((String)"Check duplicate").model(Wizard.class.getName()).add("form", "wizard-check-duplicate-form").param("popup", "true").param("show-toolbar", "false").param("width", "500").param("popup-save", "false").context("_contextModel", (Object)request.getModel()).context("_criteria", (Object)criteria).map());
    }

    private String getCriteria(ActionRequest request, Class<? extends Model> modelClass) {
        String criteria = (String)request.getContext().get((Object)"_criteria");
        if (criteria != null) {
            return criteria;
        }
        List contextIds = (List)request.getContext().get((Object)"_ids");
        if (contextIds != null && !contextIds.isEmpty()) {
            return "self.id in (" + Joiner.on((String)",").join((Iterable)contextIds) + ")";
        }
        List listObj = request.getCriteria().createQuery(modelClass).select(new String[]{"id"}).fetch(0, 0);
        if (listObj != null) {
            List ids = listObj.stream().map(it -> it.get("id")).collect(Collectors.toList());
            LOG.debug("Total criteria ids: {}", (Object)ids.size());
            return "self.id in (" + Joiner.on((String)",").join(ids) + ")";
        }
        return null;
    }
}

