/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.web;

import com.axelor.apps.base.db.ImportHistory;
import com.axelor.apps.base.service.imports.ImportCityService;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.db.repo.MetaFileRepository;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.LinkedHashMap;

@Singleton
public class ImportCityController {
    @Inject
    private ImportCityService importCityService;

    public void importCity(ActionRequest request, ActionResponse response) {
        MetaFile dataFile = new MetaFile();
        String typeSelect = (String)request.getContext().get((Object)"typeSelect");
        if (typeSelect.equals("geonames")) {
            LinkedHashMap map = (LinkedHashMap)request.getContext().get((Object)"metaFile");
            ArrayList<ImportHistory> importHistoryList = new ArrayList<ImportHistory>();
            String downloadFileName = (String)request.getContext().get((Object)"autoImportTypeSelect");
            try {
                if (map != null) {
                    dataFile = (MetaFile)((MetaFileRepository)Beans.get(MetaFileRepository.class)).find(Long.valueOf(Long.parseLong(map.get("id").toString())));
                    importHistoryList.add(this.importCityService.importCity(typeSelect, dataFile));
                }
                if (downloadFileName != null) {
                    dataFile = this.importCityService.downloadZip(downloadFileName);
                    importHistoryList.add(this.importCityService.importCity(typeSelect, dataFile));
                }
                response.setAttr("$importHistoryList", "hidden", (Object)false);
                response.setAttr("$importHistoryList", "value", importHistoryList);
                response.setFlash(I18n.get((String)"City import completed"));
            }
            catch (Exception e) {
                TraceBackService.trace((ActionResponse)response, (Throwable)e);
            }
        }
    }
}

