/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.web;

import com.axelor.apps.base.db.ImportConfiguration;
import com.axelor.apps.base.db.ImportHistory;
import com.axelor.apps.base.service.imports.ImportService;
import com.axelor.exception.service.TraceBackService;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import java.io.File;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.FileUtils;

@Singleton
public class ImportConfigurationController {
    public void run(ActionRequest request, ActionResponse response) {
        ImportConfiguration importConfiguration = (ImportConfiguration)((Object)request.getContext().asType(ImportConfiguration.class));
        try {
            ImportHistory importHistory = ((ImportService)Beans.get(ImportService.class)).run(importConfiguration);
            response.setAttr("importHistoryList", "value:add", (Object)importHistory);
            File readFile = MetaFiles.getPath((MetaFile)importHistory.getLogMetaFile()).toFile();
            response.setNotify(FileUtils.readFileToString((File)readFile, (Charset)StandardCharsets.UTF_8).replaceAll("(\r\n|\n\r|\r|\n)", "<br />"));
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

