/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.web;

import com.axelor.apps.base.service.imports.ImportDemoDataService;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.db.repo.MetaFileRepository;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.common.io.Files;
import com.google.inject.Singleton;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.text.ParseException;
import java.util.Map;

@Singleton
public class ImportDemoDataController {
    public void importDemoDataExcel(ActionRequest request, ActionResponse response) throws FileNotFoundException, IOException, AxelorException, ParseException, ClassNotFoundException {
        MetaFile metaFile = (MetaFile)((MetaFileRepository)Beans.get(MetaFileRepository.class)).find(Long.valueOf(((Map)request.getContext().get((Object)"importFile")).get("id").toString()));
        File excelFile = MetaFiles.getPath((MetaFile)metaFile).toFile();
        if (Files.getFileExtension((String)excelFile.getName()).equals("xlsx")) {
            File tmpFile = File.createTempFile("Import", ".log");
            if (((ImportDemoDataService)Beans.get(ImportDemoDataService.class)).importDemoDataExcel(excelFile, tmpFile)) {
                response.setFlash(I18n.get((String)"Import completed successfully. Please check the log for more details."));
            } else {
                response.setFlash(I18n.get((String)"Invalid data format. Please check log for more details."));
            }
            response.setAttr("$logFile", "hidden", (Object)false);
            FileInputStream inStream = new FileInputStream(tmpFile);
            response.setValue("$logFile", (Object)((MetaFiles)Beans.get(MetaFiles.class)).upload((InputStream)inStream, "Import.log"));
        } else {
            response.setError(I18n.get((String)"Please import only excel file."));
        }
    }
}

