/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.web;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.message.db.Message;
import com.axelor.apps.message.db.repo.MessageRepository;
import com.axelor.apps.message.service.MessageService;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.inject.Singleton;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class MessageController
extends com.axelor.apps.message.web.MessageController {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void printMessage(ActionRequest request, ActionResponse response) throws AxelorException {
        Message message = (Message)((Object)request.getContext().asType(Message.class));
        String pdfPath = ((MessageService)Beans.get(MessageService.class)).printMessage(message);
        if (pdfPath != null) {
            response.setView(ActionView.define((String)("Message " + message.getSubject())).add("html", pdfPath).map());
        } else {
            response.setFlash(I18n.get((String)"Error in print. Please check report configuration and print setting."));
        }
    }

    public void print(ActionRequest request, ActionResponse response) throws AxelorException {
        Message message = (Message)((Object)request.getContext().asType(Message.class));
        String messageIds = "";
        List lstSelectedMessages = (List)request.getContext().get((Object)"_ids");
        if (lstSelectedMessages != null) {
            for (Integer it : lstSelectedMessages) {
                messageIds = messageIds + it.toString() + ",";
            }
        }
        if (!messageIds.equals("")) {
            messageIds = messageIds.substring(0, messageIds.length() - 1);
            message = (Message)((Object)((MessageRepository)((Object)Beans.get(MessageRepository.class))).find(new Long(((Integer)lstSelectedMessages.get(0)).intValue())));
        } else if (message.getId() != null) {
            messageIds = message.getId().toString();
        }
        if (!messageIds.equals("")) {
            String language = ReportSettings.getPrintingLocale(null);
            String title = " ";
            if (message.getSubject() != null) {
                title = title + (lstSelectedMessages == null ? "Message " + message.getSubject() : "Messages");
            }
            String fileLink = ReportFactory.createReport("MessagePDF.rptdesign", title + "-${date}").addParam("Locale", language).addParam("MessageId", messageIds).addParam("Timezone", null).addFormat("xls").generate().getFileLink();
            this.logger.debug("Printing " + title);
            response.setView(ActionView.define((String)title).add("html", fileLink).map());
        } else {
            response.setFlash(I18n.get((String)"Please select the Message(s) to print."));
        }
    }
}

