/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.web;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.base.db.Bank;
import com.axelor.apps.base.db.BankDetails;
import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.repo.CompanyRepository;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.service.BankDetailsService;
import com.axelor.apps.base.service.MapService;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.apps.base.service.administration.SequenceService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.base.service.user.UserService;
import com.axelor.apps.message.db.Message;
import com.axelor.apps.message.db.repo.MessageRepository;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.auth.AuthUtils;
import com.axelor.auth.db.User;
import com.axelor.common.StringUtils;
import com.axelor.db.Model;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.CallMethod;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.axelor.rpc.Context;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.inject.Singleton;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.iban4j.IbanFormatException;
import org.iban4j.InvalidCheckDigitException;
import org.iban4j.UnsupportedCountryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class PartnerController {
    private static final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void setPartnerSequence(ActionRequest request, ActionResponse response) throws AxelorException {
        Partner partner = (Partner)((Object)request.getContext().asType(Partner.class));
        partner = (Partner)((Object)((PartnerRepository)((Object)Beans.get(PartnerRepository.class))).find(partner.getId()));
        if (partner.getPartnerSeq() == null) {
            String seq = ((SequenceService)Beans.get(SequenceService.class)).getSequenceNumber("partner");
            if (seq == null) {
                throw new AxelorException((Model)((Object)partner), 4, I18n.get((String)"There is no sequence set for the partners"));
            }
            response.setValue("partnerSeq", (Object)seq);
        }
    }

    public void showEnvelope(ActionRequest request, ActionResponse response) throws AxelorException {
        Partner partner = (Partner)((Object)request.getContext().asType(Partner.class));
        String name = I18n.get((String)"Partner") + " " + partner.getPartnerSeq();
        String fileLink = ReportFactory.createReport("Partner.rptdesign", name + "-${date}").addParam("Locale", ReportSettings.getPrintingLocale(partner)).addParam("Timezone", this.getTimezone(partner.getUser())).addParam("PartnerId", partner.getId()).generate().getFileLink();
        LOG.debug("Printing " + name);
        response.setView(ActionView.define((String)name).add("html", fileLink).map());
    }

    public void printContactPhonebook(ActionRequest request, ActionResponse response) throws AxelorException {
        User user = AuthUtils.getUser();
        String name = I18n.get((String)"Phone Book");
        String fileLink = ReportFactory.createReport("ContactPhoneBook.rptdesign", name + "-${date}").addParam("Locale", ReportSettings.getPrintingLocale(null)).addParam("Timezone", this.getTimezone(user)).addParam("UserId", user.getId()).generate().getFileLink();
        LOG.debug("Printing " + name);
        response.setView(ActionView.define((String)name).add("html", fileLink).map());
    }

    public void printCompanyPhonebook(ActionRequest request, ActionResponse response) throws AxelorException {
        User user = AuthUtils.getUser();
        String name = I18n.get((String)"Company PhoneBook");
        String fileLink = ReportFactory.createReport("CompanyPhoneBook.rptdesign", name + "-${date}").addParam("Locale", ReportSettings.getPrintingLocale(null)).addParam("Timezone", this.getTimezone(user)).addParam("UserId", user.getId()).generate().getFileLink();
        LOG.debug("Printing " + name);
        response.setView(ActionView.define((String)name).add("html", fileLink).map());
    }

    public void printClientSituation(ActionRequest request, ActionResponse response) throws AxelorException {
        Partner partner = (Partner)((Object)request.getContext().asType(Partner.class));
        User user = AuthUtils.getUser();
        String name = I18n.get((String)"Customer Situation");
        String fileLink = ReportFactory.createReport("ClientSituation.rptdesign", name + "-${date}").addParam("Locale", ReportSettings.getPrintingLocale(partner)).addParam("Timezone", this.getTimezone(user)).addParam("UserId", user.getId()).addParam("PartnerId", partner.getId()).addParam("PartnerPic", partner.getPicture() != null ? MetaFiles.getPath((MetaFile)partner.getPicture()).toString() : "").generate().getFileLink();
        LOG.debug("Printing " + name);
        response.setView(ActionView.define((String)name).add("html", fileLink).map());
    }

    private String getTimezone(User user) {
        if (user == null || user.getActiveCompany() == null) {
            return null;
        }
        return user.getActiveCompany().getTimezone();
    }

    @CallMethod
    public Company getActiveCompany() {
        List companyList;
        Company company = ((UserService)Beans.get(UserService.class)).getUser().getActiveCompany();
        if (company == null && (companyList = ((CompanyRepository)((Object)Beans.get(CompanyRepository.class))).all().fetch()).size() == 1) {
            company = (Company)((Object)companyList.get(0));
        }
        return company;
    }

    public void setSocialNetworkUrl(ActionRequest request, ActionResponse response) {
        Partner partner = (Partner)((Object)request.getContext().asType(Partner.class));
        Map<String, String> urlMap = ((PartnerService)Beans.get(PartnerService.class)).getSocialNetworkUrl(partner.getName(), partner.getFirstName(), partner.getPartnerTypeSelect());
        response.setAttr("googleLabel", "title", (Object)urlMap.get("google"));
        response.setAttr("facebookLabel", "title", (Object)urlMap.get("facebook"));
        response.setAttr("twitterLabel", "title", (Object)urlMap.get("twitter"));
        response.setAttr("linkedinLabel", "title", (Object)urlMap.get("linkedin"));
        response.setAttr("youtubeLabel", "title", (Object)urlMap.get("youtube"));
    }

    public void findPartnerMails(ActionRequest request, ActionResponse response) {
        Partner partner = (Partner)((Object)request.getContext().asType(Partner.class));
        List<Long> idList = ((PartnerService)Beans.get(PartnerService.class)).findPartnerMails(partner);
        ArrayList<Message> emailsList = new ArrayList<Message>();
        for (Long id : idList) {
            Message message = (Message)((Object)((MessageRepository)((Object)Beans.get(MessageRepository.class))).find(id));
            if (emailsList.contains((Object)message)) continue;
            emailsList.add(message);
        }
        response.setValue("$emailsList", emailsList);
    }

    public void addContactToPartner(ActionRequest request, ActionResponse response) {
        try {
            Context context = request.getContext();
            Partner contact = (Partner)((Object)context.asType(Partner.class));
            Context parentContext = context.getParent();
            if (parentContext != null && Partner.class.isAssignableFrom(parentContext.getContextClass()) && Objects.equals(parentContext.asType(Partner.class), (Object)contact.getMainPartner())) {
                return;
            }
            ((PartnerService)Beans.get(PartnerService.class)).addContactToPartner((Partner)((Object)((PartnerRepository)((Object)Beans.get(PartnerRepository.class))).find(contact.getId())));
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void findContactMails(ActionRequest request, ActionResponse response) {
        Partner partner = (Partner)((Object)request.getContext().asType(Partner.class));
        List<Long> idList = ((PartnerService)Beans.get(PartnerService.class)).findContactMails(partner);
        ArrayList<Message> emailsList = new ArrayList<Message>();
        for (Long id : idList) {
            Message message = (Message)((Object)((MessageRepository)((Object)Beans.get(MessageRepository.class))).find(id));
            if (emailsList.contains((Object)message)) continue;
            emailsList.add(message);
        }
        response.setValue("$emailsList", emailsList);
    }

    public void checkIbanValidity(ActionRequest request, ActionResponse response) throws AxelorException {
        List<BankDetails> bankDetailsList = ((Partner)((Object)request.getContext().asType(Partner.class))).getBankDetailsList();
        ArrayList ibanInError = Lists.newArrayList();
        if (bankDetailsList != null && !bankDetailsList.isEmpty()) {
            for (BankDetails bankDetails : bankDetailsList) {
                Bank bank = bankDetails.getBank();
                if (bankDetails.getIban() == null || bank == null || bank.getBankDetailsTypeSelect() != 1) continue;
                LOG.debug("checking iban code : {}", (Object)bankDetails.getIban());
                try {
                    ((BankDetailsService)Beans.get(BankDetailsService.class)).validateIban(bankDetails.getIban());
                }
                catch (IbanFormatException | InvalidCheckDigitException | UnsupportedCountryException e) {
                    ibanInError.add(bankDetails.getIban());
                }
            }
        }
        if (!ibanInError.isEmpty()) {
            Function<String, String> addLi = new Function<String, String>(){

                public String apply(String s) {
                    return "<li>".concat(s).concat("</li>").toString();
                }
            };
            response.setAlert(String.format("At least one iban code you have entered for this partner is not valid. Here is the list of invalid codes : %s", "<ul>" + Joiner.on((String)"").join(Iterables.transform((Iterable)ibanInError, (Function)addLi)) + "<ul>"));
        }
    }

    public void normalizePhoneNumber(ActionRequest request, ActionResponse response) {
        PartnerService partnerService = (PartnerService)Beans.get(PartnerService.class);
        try {
            String phoneNumberFieldName = partnerService.getPhoneNumberFieldName(request.getAction());
            String phoneNumber = (String)request.getContext().get((Object)phoneNumberFieldName);
            if (!StringUtils.isBlank((CharSequence)phoneNumber)) {
                String normalizedPhoneNumber = partnerService.normalizePhoneNumber(phoneNumber);
                if (!phoneNumber.equals(normalizedPhoneNumber)) {
                    response.setValue(phoneNumberFieldName, (Object)normalizedPhoneNumber);
                }
                if (!partnerService.checkPhoneNumber(normalizedPhoneNumber)) {
                    response.addError(phoneNumberFieldName, I18n.get((String)"Invalid phone number"));
                }
            }
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }

    public void convertToIndividualPartner(ActionRequest request, ActionResponse response) throws AxelorException {
        Partner partner = (Partner)((Object)request.getContext().asType(Partner.class));
        if (partner.getId() == null) {
            throw new AxelorException(4, I18n.get((String)"Can\u2019t convert into an individual partner from scratch."));
        }
        partner = (Partner)((Object)((PartnerRepository)((Object)Beans.get(PartnerRepository.class))).find(partner.getId()));
        ((PartnerService)Beans.get(PartnerService.class)).convertToIndividualPartner(partner);
    }

    public void checkPartnerName(ActionRequest request, ActionResponse response) {
        try {
            Partner partner = (Partner)((Object)request.getContext().asType(Partner.class));
            response.setAttr("duplicatePartnerText", "hidden", (Object)(!((PartnerService)Beans.get(PartnerService.class)).isThereDuplicatePartner(partner) ? 1 : 0));
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
    }

    public void checkPartnerNameArchived(ActionRequest request, ActionResponse response) {
        try {
            Partner partner = (Partner)((Object)request.getContext().asType(Partner.class));
            Partner partnerArchived = ((PartnerService)Beans.get(PartnerService.class)).isThereDuplicatePartnerInArchive(partner);
            if (partnerArchived != null) {
                response.setValue("$duplicatePartnerInArchiveText", (Object)partnerArchived.getPartnerSeq());
                response.setAttr("$duplicatePartnerInArchiveText", "hidden", (Object)false);
            }
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
    }

    public void showPartnerOnMap(ActionRequest request, ActionResponse response) {
        try {
            Partner partner = (Partner)((Object)request.getContext().asType(Partner.class));
            response.setView(ActionView.define((String)partner.getFullName()).add("html", ((AppBaseService)Beans.get(AppBaseService.class)).getAppBase().getMapApiSelect() == 1 ? ((MapService)Beans.get(MapService.class)).getMapURI("partner", partner.getId()) : ((MapService)Beans.get(MapService.class)).getOsmMapURI("partner", partner.getId())).map());
        }
        catch (Exception e) {
            TraceBackService.trace((Throwable)e);
        }
    }
}

