/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.base.web;

import com.axelor.apps.ReportFactory;
import com.axelor.apps.base.db.Product;
import com.axelor.apps.base.db.repo.ProductRepository;
import com.axelor.apps.base.service.ProductService;
import com.axelor.apps.base.service.app.AppBaseService;
import com.axelor.apps.base.service.user.UserService;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.auth.db.User;
import com.axelor.exception.AxelorException;
import com.axelor.exception.service.TraceBackService;
import com.axelor.i18n.I18n;
import com.axelor.inject.Beans;
import com.axelor.meta.schema.actions.ActionView;
import com.axelor.rpc.ActionRequest;
import com.axelor.rpc.ActionResponse;
import com.google.common.base.Joiner;
import com.google.inject.Singleton;
import java.lang.invoke.MethodHandles;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ProductController {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());

    public void generateProductVariants(ActionRequest request, ActionResponse response) throws AxelorException {
        Product product = (Product)((Object)request.getContext().asType(Product.class));
        product = (Product)((Object)((ProductRepository)((Object)Beans.get(ProductRepository.class))).find(product.getId()));
        if (product.getProductVariantConfig() != null) {
            ((ProductService)Beans.get(ProductService.class)).generateProductVariants(product);
            response.setFlash(I18n.get((String)"Variants generated"));
            response.setReload(true);
        }
    }

    public void updateProductsPrices(ActionRequest request, ActionResponse response) throws AxelorException {
        Product product = (Product)((Object)request.getContext().asType(Product.class));
        product = (Product)((Object)((ProductRepository)((Object)Beans.get(ProductRepository.class))).find(product.getId()));
        ((ProductService)Beans.get(ProductService.class)).updateProductPrice(product);
        response.setFlash(I18n.get((String)"Prices updated"));
        response.setReload(true);
    }

    public void printProductCatalog(ActionRequest request, ActionResponse response) throws AxelorException {
        User user = ((UserService)Beans.get(UserService.class)).getUser();
        int currentYear = ((AppBaseService)Beans.get(AppBaseService.class)).getTodayDateTime().getYear();
        String productIds = "";
        List lstSelectedProduct = (List)request.getContext().get((Object)"_ids");
        if (lstSelectedProduct != null) {
            productIds = Joiner.on((String)",").join((Iterable)lstSelectedProduct);
        }
        String name = I18n.get((String)"Product Catalog");
        String fileLink = ReportFactory.createReport("ProductCatalog_PGQL.rptdesign", name + "-${date}").addParam("UserId", user.getId()).addParam("CurrYear", Integer.toString(currentYear)).addParam("ProductIds", productIds).addParam("Locale", ReportSettings.getPrintingLocale(null)).addParam("Timezone", user.getActiveCompany() != null ? user.getActiveCompany().getTimezone() : null).generate().getFileLink();
        this.logger.debug("Printing " + name);
        response.setView(ActionView.define((String)name).add("html", fileLink).map());
    }

    public void printProductSheet(ActionRequest request, ActionResponse response) throws AxelorException {
        try {
            Product product = (Product)((Object)request.getContext().asType(Product.class));
            User user = ((UserService)Beans.get(UserService.class)).getUser();
            String name = I18n.get((String)"Product") + " " + product.getCode();
            if (user.getActiveCompany() == null) {
                throw new AxelorException(4, I18n.get((String)"No active company for this user, please define an active company."));
            }
            String fileLink = ReportFactory.createReport("ProductSheet.rptdesign", name + "-${date}").addParam("ProductId", product.getId()).addParam("CompanyId", user.getActiveCompany().getId()).addParam("Locale", ReportSettings.getPrintingLocale(null)).addParam("Timezone", user.getActiveCompany() != null ? user.getActiveCompany().getTimezone() : null).generate().getFileLink();
            this.logger.debug("Printing " + name);
            response.setView(ActionView.define((String)name).add("html", fileLink).map());
        }
        catch (Exception e) {
            TraceBackService.trace((ActionResponse)response, (Throwable)e);
        }
    }
}

