/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.apps.report.engine;

import com.axelor.app.AppSettings;
import com.axelor.apps.base.service.ReportingTool;
import com.axelor.apps.report.engine.ReportSettings;
import com.axelor.apps.tool.net.URLService;
import com.axelor.exception.AxelorException;
import com.axelor.i18n.I18n;
import com.axelor.meta.MetaFiles;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.lang.invoke.MethodHandles;
import java.net.URLEncoder;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExternalReportSettings
extends ReportSettings {
    private final Logger logger = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    protected static String BIRT_PATH = "birt";
    protected String url = "";
    protected String birtViewerUrl = null;

    public ExternalReportSettings(String rptdesign, String outputName) {
        super(rptdesign, outputName);
        this.addAxelorReportPath(rptdesign).addParam("__locale", ReportingTool.getCompanyLocale().toString());
    }

    @Override
    public ExternalReportSettings generate() throws AxelorException {
        super.generate();
        try {
            this.getUrl();
            String urlNotExist = URLService.notExist((String)this.url.toString());
            if (urlNotExist != null) {
                throw new AxelorException(4, I18n.get((String)"Impossible to generate report, url toward Birt viewer is not correctly configured (%s)"), new Object[]{this.birtViewerUrl});
            }
            Path tmpFile = MetaFiles.createTempFile(null, (String)"", (FileAttribute[])new FileAttribute[0]);
            this.output = tmpFile.toFile();
            URLService.fileDownload((File)this.output, (String)this.url, (String)"", (String)this.outputName);
            this.attach();
        }
        catch (IOException ioe) {
            throw new AxelorException((Throwable)ioe, 4);
        }
        return this;
    }

    public String getUrl() {
        this.addParam("__format", this.format);
        for (String param : this.params.keySet()) {
            try {
                this.url = this.url + this.computeParam(param);
            }
            catch (UnsupportedEncodingException e) {
                this.logger.error(e.getLocalizedMessage());
            }
        }
        return this.url;
    }

    private String computeParam(String param) throws UnsupportedEncodingException {
        return "&" + param + "=" + URLEncoder.encode(this.params.get(param).toString(), "UTF-8");
    }

    private ReportSettings addAxelorReportPath(String rptdesign) {
        AppSettings appsSettings = AppSettings.get();
        String defaultUrl = appsSettings.getBaseURL();
        defaultUrl = defaultUrl.substring(0, defaultUrl.lastIndexOf(47));
        defaultUrl = defaultUrl + "/" + BIRT_PATH;
        this.birtViewerUrl = appsSettings.get("axelor.report.engine", defaultUrl);
        String resourcePath = appsSettings.get("axelor.report.resource.path", "report");
        resourcePath = resourcePath.endsWith("/") ? resourcePath : resourcePath + "/";
        this.url = this.url + this.birtViewerUrl + "/frameset?__report=" + resourcePath + rptdesign;
        return this;
    }
}

