/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.csv.script;

import com.axelor.apps.base.db.FileTab;
import com.axelor.apps.base.db.repo.FileTabRepository;
import com.axelor.apps.base.service.advanced.imports.ActionService;
import com.axelor.apps.base.service.advanced.imports.ValidatorService;
import com.axelor.common.Inflector;
import com.axelor.common.ObjectUtils;
import com.axelor.db.EntityHelper;
import com.axelor.db.JPA;
import com.axelor.db.Model;
import com.axelor.db.mapper.Mapper;
import com.axelor.db.mapper.Property;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.axelor.rpc.Context;
import com.axelor.rpc.JsonContext;
import com.axelor.script.GroovyScriptHelper;
import com.axelor.script.ScriptBindings;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.script.Bindings;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class ImportAdvancedImport {
    @Inject
    protected MetaFiles metaFiles;
    @Inject
    private FileTabRepository fileTabRepo;
    @Inject
    private ValidatorService validatorService;
    @Inject
    protected ActionService actionService;

    public Object importGeneral(Object bean, Map<String, Object> values) throws ClassNotFoundException {
        String ACTIONS_TO_APPLY;
        if (bean == null) {
            return bean;
        }
        FileTab fileTab = (FileTab)((Object)this.fileTabRepo.find(Long.valueOf(values.get("fileTabId").toString())));
        GroovyScriptHelper scriptHelper = new GroovyScriptHelper((Bindings)new ScriptBindings(values));
        List exprs = (List)values.get("ifConditions" + fileTab.getId());
        if (!CollectionUtils.isEmpty((Collection)exprs) && ((Boolean)scriptHelper.eval(String.join((CharSequence)" || ", exprs))).booleanValue()) {
            return null;
        }
        if (((Model)bean).getId() == null) {
            List<Property> propList = this.getProperties(bean);
            JPA.save((Model)((Model)bean));
            this.addJsonObjectRecord(bean, fileTab, fileTab.getMetaModel().getName(), values);
            int fieldSeq = 2;
            int btnSeq = 3;
            for (Property prop : propList) {
                this.validatorService.createCustomObjectSet(((Object)((Object)fileTab)).getClass().getName(), prop.getTarget().getName(), fieldSeq);
                this.validatorService.createCustomButton(((Object)((Object)fileTab)).getClass().getName(), prop.getTarget().getName(), btnSeq);
                this.addJsonObjectRecord(prop.get(bean), fileTab, StringUtils.substringAfterLast((String)prop.getTarget().getName(), (String)"."), values);
                ++fieldSeq;
                ++btnSeq;
            }
        }
        if (!ObjectUtils.isEmpty((Object)values.get(ACTIONS_TO_APPLY = "actionsToApply" + fileTab.getId()))) {
            bean = this.actionService.apply(values.get(ACTIONS_TO_APPLY).toString(), bean);
        }
        return bean;
    }

    private List<Property> getProperties(Object bean) {
        ArrayList<Property> propList = new ArrayList<Property>();
        for (Property prop : Mapper.of(bean.getClass()).getProperties()) {
            if (prop.getTarget() == null || prop.isCollection() || (Model)prop.get(bean) == null || ((Model)prop.get(bean)).getId() != null) continue;
            propList.add(prop);
        }
        return propList;
    }

    private void addJsonObjectRecord(Object bean, FileTab fileTab, String fieldName, Map<String, Object> values) {
        String field = Inflector.getInstance().camelize(fieldName, true) + "Set";
        HashMap<String, Long> recordMap = new HashMap<String, Long>();
        recordMap.put("id", ((Model)bean).getId());
        Map jsonContextValues = (Map)values.get("jsonContextValues" + fileTab.getId());
        JsonContext jsonContext = (JsonContext)jsonContextValues.get("jsonContext");
        Context context = (Context)jsonContextValues.get("context");
        List<HashMap<String, Long>> recordList = !jsonContext.containsKey((Object)field) ? new ArrayList<HashMap<String, Long>>() : ((List)jsonContext.get((Object)field)).stream().map(obj -> {
            if (Mapper.toMap((Object)EntityHelper.getEntity((Object)obj)).get("id") != null) {
                HashMap idMap = new HashMap();
                idMap.put("id", Mapper.toMap((Object)EntityHelper.getEntity((Object)obj)).get("id"));
                return idMap;
            }
            return obj;
        }).collect(Collectors.toList());
        recordList.add(recordMap);
        jsonContext.put(field, recordList);
        fileTab.setAttrs(context.get((Object)"attrs").toString());
    }

    public Object importPicture(String value, String pathVal) throws IOException {
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        Path path = Paths.get(pathVal, new String[0]);
        if (Strings.isNullOrEmpty((String)value)) {
            return null;
        }
        File image = path.resolve(value).toFile();
        if (!image.exists() || image.isDirectory()) {
            return null;
        }
        MetaFile metaFile = this.metaFiles.upload(image);
        return metaFile;
    }
}

