/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.csv.script;

import com.axelor.apps.base.db.Company;
import com.axelor.common.StringUtils;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.google.inject.Inject;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.nio.file.Path;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportCompany {
    private final Logger LOG = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    @Inject
    MetaFiles metaFiles;

    public Object importCompany(Object bean, Map<String, Object> values) {
        assert (bean instanceof Company);
        Company company = (Company)((Object)bean);
        String fileName = (String)values.get("logo_fileName");
        if (!StringUtils.isEmpty((CharSequence)fileName)) {
            Path path = (Path)values.get("__path__");
            try {
                File image = path.resolve(fileName).toFile();
                if (image != null && image.isFile()) {
                    MetaFile metaFile = this.metaFiles.upload(image);
                    company.setLogo(metaFile);
                }
            }
            catch (Exception e) {
                this.LOG.error("Error when importing company : {}", (Throwable)e);
            }
        }
        return company;
    }
}

