/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.csv.script;

import com.axelor.apps.base.db.Partner;
import com.axelor.apps.base.db.repo.PartnerRepository;
import com.axelor.apps.base.service.PartnerService;
import com.axelor.meta.MetaFiles;
import com.axelor.meta.db.MetaFile;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ImportPartner {
    @Inject
    protected PartnerRepository partnerRepo;
    @Inject
    protected MetaFiles metaFiles;
    @Inject
    protected PartnerService partnerService;

    public Object importPartner(Object bean, Map<String, Object> values) {
        assert (bean instanceof Partner);
        Partner partner = (Partner)((Object)bean);
        this.partnerService.setPartnerFullName(partner);
        Path path = (Path)values.get("__path__");
        String fileName = (String)values.get("picture_fileName");
        if (Strings.isNullOrEmpty((String)fileName)) {
            return bean;
        }
        File image = path.resolve(fileName).toFile();
        try {
            MetaFile metaFile = this.metaFiles.upload(image);
            partner.setPicture(metaFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return bean;
    }

    public Object updateContacts(Object bean, Map<String, Object> values) {
        assert (bean instanceof Partner);
        Partner partner = (Partner)((Object)bean);
        partner.setContactPartnerSet(new HashSet<Partner>());
        List partnerList = this.partnerRepo.all().filter("self.mainPartner.id = ?1", new Object[]{partner.getId()}).fetch();
        for (Partner pt : partnerList) {
            partner.getContactPartnerSet().add(pt);
        }
        return partner;
    }
}

