/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.csv.script;

import com.axelor.auth.db.Group;
import com.axelor.auth.db.Permission;
import com.axelor.auth.db.Role;
import com.axelor.auth.db.repo.GroupRepository;
import com.axelor.auth.db.repo.PermissionRepository;
import com.axelor.auth.db.repo.RoleRepository;
import com.axelor.db.Model;
import com.axelor.inject.Beans;
import com.google.common.base.Strings;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class ImportPermission {
    @Inject
    PermissionRepository permissionRepo;

    @Transactional
    public Object importPermission(Object bean, Map<String, Object> values) {
        assert (bean instanceof Permission);
        try {
            GroupRepository groupRepository = (GroupRepository)((Object)Beans.get(GroupRepository.class));
            Permission permission = (Permission)((Object)bean);
            String groups = (String)values.get("group");
            if (permission.getId() != null && groups != null && !groups.isEmpty()) {
                for (Group group : groupRepository.all().filter("code in ?1", new Object[]{Arrays.asList(groups.split("\\|"))}).fetch()) {
                    Set<Permission> permissions = group.getPermissions();
                    if (permissions == null) {
                        permissions = new HashSet<Permission>();
                    }
                    permissions.add((Permission)((Object)this.permissionRepo.find(permission.getId())));
                    group.setPermissions(permissions);
                    groupRepository.save((Model)((Object)group));
                }
            }
            return permission;
        }
        catch (Exception e) {
            e.printStackTrace();
            return bean;
        }
    }

    @Transactional
    public Object importPermissionToRole(Object bean, Map<String, Object> values) {
        assert (bean instanceof Permission);
        Permission permission = (Permission)((Object)bean);
        String roleName = values.get("roleName").toString();
        if (Strings.isNullOrEmpty((String)roleName)) {
            return bean;
        }
        RoleRepository roleRepository = (RoleRepository)((Object)Beans.get(RoleRepository.class));
        Role role = roleRepository.findByName(roleName);
        if (role == null) {
            return bean;
        }
        role.addPermission(permission);
        return bean;
    }
}

