/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.csv.script;

import com.axelor.apps.base.db.Company;
import com.axelor.apps.base.db.Period;
import com.axelor.apps.base.db.Year;
import com.axelor.apps.base.db.repo.PeriodRepository;
import com.axelor.apps.base.db.repo.YearRepository;
import com.axelor.db.Model;
import com.google.inject.Inject;
import com.google.inject.persist.Transactional;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Map;

public class UpdateAll {
    @Inject
    private YearRepository yearRepo;
    @Inject
    private PeriodRepository periodRepo;

    @Transactional
    public Object updatePeriod(Object bean, Map<String, Object> values) {
        try {
            assert (bean instanceof Company);
            Company company = (Company)((Object)bean);
            for (Year year : this.yearRepo.all().filter("self.company.id = ?1 AND self.typeSelect = 1", new Object[]{company.getId()}).fetch()) {
                if (!year.getPeriodList().isEmpty()) continue;
                for (Integer month : Arrays.asList(1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12)) {
                    Period period = new Period();
                    LocalDate dt = LocalDate.of(year.getFromDate().getYear(), month, 1);
                    period.setFromDate(dt.withDayOfMonth(1));
                    period.setToDate(dt.withDayOfMonth(dt.lengthOfMonth()));
                    period.setYear(year);
                    period.setStatusSelect(1);
                    period.setCode((dt.toString().split("-")[1] + "/" + year.getCode().split("_")[0] + "_" + company.getCode()).toUpperCase());
                    period.setName(dt.toString().split("-")[1] + '/' + year.getName());
                    this.periodRepo.save((Model)((Object)period));
                }
            }
            return company;
        }
        catch (Exception e) {
            e.printStackTrace();
            return bean;
        }
    }
}

