/*
 * Decompiled with CFR 0.152.
 */
package com.axelor.common;

import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class Inflections {
    private static final Map<String, Inflections> INSTANCES = new ConcurrentHashMap<String, Inflections>();
    private static final String DEFAULT_LANG = "en";
    private Set<String> ignored = new HashSet<String>();
    private List<Rule> singulars = new LinkedList<Rule>();
    private List<Rule> plurals = new LinkedList<Rule>();

    private Inflections() {
    }

    public static Inflections getInstance() {
        return Inflections.getInstance(DEFAULT_LANG);
    }

    public static Inflections getInstance(String language) {
        Inflections instance = INSTANCES.get(language);
        if (instance == null) {
            instance = new Inflections();
            INSTANCES.put(language, instance);
        }
        return instance;
    }

    private String capitalize(String word) {
        return Character.toUpperCase(word.charAt(0)) + word.substring(1).toLowerCase();
    }

    public void ignore(String ... words) {
        if (words != null) {
            for (String word : words) {
                this.ignored.add(word.toLowerCase());
            }
        }
    }

    public void irregular(String singular, String plural) {
        this.plurals.add(0, new Rule(singular.toLowerCase(), plural.toLowerCase(), true));
        this.plurals.add(0, new Rule(this.capitalize(singular), this.capitalize(plural), true));
        this.singulars.add(0, new Rule(plural.toLowerCase(), singular.toLowerCase(), true));
        this.singulars.add(0, new Rule(this.capitalize(plural), this.capitalize(singular), true));
    }

    public void singular(String pattern, String replacement) {
        this.singulars.add(0, new Rule(pattern, replacement, false));
    }

    public void plural(String pattern, String replacement) {
        this.plurals.add(0, new Rule(pattern, replacement, false));
    }

    protected String apply(String word, List<Rule> rules) {
        if (word == null || "".equals(word.trim())) {
            return word;
        }
        if (this.ignored.contains(word.toLowerCase())) {
            return word;
        }
        for (Rule rule : rules) {
            String result = rule.apply(word);
            if (result == null) continue;
            return result;
        }
        return word;
    }

    public String singularize(String word) {
        return this.apply(word, this.singulars);
    }

    public String pluralize(String word) {
        return this.apply(word, this.plurals);
    }

    static class Rule {
        private String pattern;
        private String replacement;
        private Pattern regex;

        public Rule(String pattern, String replacement, boolean simple) {
            this.pattern = pattern;
            this.replacement = replacement;
            if (!simple) {
                this.regex = Pattern.compile(pattern, 2);
            }
        }

        public String apply(String input) {
            if (input == null) {
                return null;
            }
            if (input.trim().equals("")) {
                return null;
            }
            if (this.regex == null) {
                return this.pattern.equals(input) ? this.replacement : null;
            }
            Matcher matcher = this.regex.matcher(input);
            if (matcher.find()) {
                return matcher.replaceAll(this.replacement);
            }
            return null;
        }

        public int hashCode() {
            return this.pattern.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            return obj instanceof Rule && this.pattern.equals(((Rule)obj).pattern);
        }
    }
}

